#include <avr/io.h>
#include "pinops.h"
#include "configuration.h"

// PWM full period
// 14.745600 Mhz / 8 / 50 Hz = 36864
#define PWM_PERIOD      (F_CPU / 8 / 50)

// PWM servo middle position
// 36864 / 20 ms * 1.5 ms = 2764
#define PWM_MIDDLE_POS  (PWM_PERIOD * 15 / 200)

// PWM ratio to get position from -100 to 100
// 36864 / 20 ms / 2 / 100
// We add +1 to get a full range and a little bit more
#define PWM_RATIO       (PWM_PERIOD / 20 / 2 / 100 + 1)

//
// Initialize motors
//
void dcmotors_init(void)
{
	setup_output_pin(DCMOTOR_1A);
	setup_output_pin(DCMOTOR_1B);
	setup_output_pin(DCMOTOR_2A);
	setup_output_pin(DCMOTOR_2B);
	setup_output_pin(DCMOTOR_3A);
	setup_output_pin(DCMOTOR_3B);
	setup_output_pin(DCMOTOR_4A);
	setup_output_pin(DCMOTOR_4B);
}

//
// Drive command for specified motor
//
void dcmotors_drive(unsigned char nr, signed char dir)
{
	switch (nr)
	{
		case 1:
			set_pin_to(DCMOTOR_1A, dir < 0);			
			set_pin_to(DCMOTOR_1B, dir > 0);
			break;

		case 2:
			set_pin_to(DCMOTOR_2A, dir < 0);			
			set_pin_to(DCMOTOR_2B, dir > 0);
			break;

		case 3:
			set_pin_to(DCMOTOR_3A, dir < 0);			
			set_pin_to(DCMOTOR_3B, dir > 0);
			break;

		case 4:
			set_pin_to(DCMOTOR_4A, dir < 0);			
			set_pin_to(DCMOTOR_4B, dir > 0);
			break;
	}
}

//
// Intialize servo motors
//
void servomotors_init(void)
{
	setup_output_pin(SERVOMOTOR_1);
	setup_output_pin(SERVOMOTOR_2);

	// Set timer control registers
	// Clear OUTA and OUTB on compare match
	// Fast PWM mode with ICR = TOP
	// Prescaler 8
	TCCR1A = BIT(COM1A1) | BIT(COM1B1) | BIT(WGM11);
	TCCR1B = BIT(CS11) | BIT(WGM13) | BIT(WGM12); 

	// TOP period	
	ICR1 = PWM_PERIOD;
}

//
// Position servo motors
// pos is from -100 to 100
//
void servomotors_position(unsigned char nr, signed short pos)
{
	// 
	switch (nr)
	{
		case 1: OCR1A = PWM_MIDDLE_POS + pos * PWM_RATIO; break;
		case 2: OCR1B = PWM_MIDDLE_POS + pos * PWM_RATIO; break;
	}
}
