#include <avr/io.h>
#include <util/delay.h>
#include <stdlib.h>
#include "adc.h"
#include "motors.h"
#include "lcd.h"
#include "segment_display.h"
#include "pinops.h"
#include "configuration.h"

// Math operations
#define DIFF(a, b) ((a) < (b) ? (b) - (a) : (a) - (b))
#define INTEGRATE(value, new_value, n)    value = (value * (n - 1) + new_value) / n;

//
// Main entrance
//
int main(void)
{
	unsigned short distance, compare_distance = 0;
	unsigned char matches = 0, num_fingers = 0;
	signed short servo_pos = -100, scan_dir = 1;
	char text[10];

	// Initialize
	adc_init();
	dcmotors_init();
	segment_display_init();
	servomotors_init();
	setup_output_pin(LED_RED);	

	lcd_init(LCD_DISP_ON);
	lcd_clrscr();
	lcd_puts("Finger counter");

	// Endless loop
	while (1)
	{	
		// Scan
		servomotors_position(1, servo_pos);
		servo_pos += scan_dir;

		// Servo on edge ?
		if ((servo_pos < -100) || (servo_pos > 100))
		{
			scan_dir = (servo_pos > 0 ? -1 : 1);

			// Output results
			segment_display_write(num_fingers);
			itoa(num_fingers, text, 10);
			lcd_gotoxy(0, 1);
			lcd_puts(text);
			lcd_puts("  ");

			// Reset fingers count
			num_fingers = 0;
		}

		// Measure distance
		distance = adc_sample_value(0, 4);		

		// Check for drastic changes
		// Look for decreasing distance (increasing sensor output voltage)
		if (distance > compare_distance + 100)		    
		{
			// Light on finger
			clear_pin(LED_RED); // inverted!

			// Changes has to last for some time
			if (matches++ == 5)
			{				
				// Count fingers
				num_fingers++;			
			}
		}
		else
		{
			// Reset matches and turn off the LED
			set_pin(LED_RED); // inverted!
			matches = 0;			
		}

		// Calculate compare distance (integrated distance) 
		INTEGRATE(compare_distance, distance, 20);

		// Pause
		_delay_ms(10);
	}
}
