#include <avr/io.h>
#include "pinops.h"

//
// ADC initialization
//
void adc_init(void)
{
	// ADC setup
	// Prescaler 8
	ADCSRA = BIT(ADEN) | BIT(ADPS1) | BIT(ADPS0);

	// Reference voltage to external (+5V)
	ADMUX = BIT(REFS0);
}

//
// ADC conversion waiting
//
void adc_wait_until_done(void)
{
	while (IS_BIT_SET(ADCSRA, ADSC))
	{
		asm volatile ("nop");
  	}
}

//
// ADC channel value sampling
//
unsigned short adc_sample_value(unsigned char channel, unsigned char num_samples)
{	
	unsigned short result = 0;

	// Specify channel
	ADMUX &= 0xF0;
	ADMUX |= channel & 0x0F;

	// Take test sample to "warm up" converter
	// Usually the first sample is discarded
	SET_BIT(ADCSRA, ADSC);
	adc_wait_until_done();
	
	// Real sampling, sum up specifed number of samples
	for (unsigned char i = 0; i < num_samples;i++)
	{
		SET_BIT(ADCSRA, ADSC);
		adc_wait_until_done();

		// Sum-up
		result += ADCW;
	}

	// Return averaged result
	return (result / num_samples);	
}
