//
// SPI interface common operations library
// Homelab library
//
// Department of Mechatronics
// Tallinn University of Technology
// ITT Group
//  Copyrights 2014
//

//
// Include spi.h for definitions
//
#include "spi.h"

//
// Include avrlibc files
//
#include <avr/io.h>

#if defined (__AVR_ATxmega128A1U__)

/*! \brief SPI master module. */
SPI_Master_t spiMasterE;

//
// SPI initialization
//
void SPI_init(void)		// Set MOSI and SCK output, all others input
{
    SPI_MasterInit(	&spiMasterE,
                    &SPIE,
                    &PORTE,
                    false,
                    SPI_MODE_0_gc,
                    SPI_INTLVL_OFF_gc,
                    false,
                    SPI_PRESCALER_DIV4_gc);
}

//
// SPI write byte
//
void SPI_write(unsigned char data)
{
    SPI_MasterTransceiveByte(&spiMasterE, data);
}
#endif