//
// SPI interface common operations library
//
// Department of Mechatronics
// Tallinn University of Technology
//  Copyrights 2011
//

//
// Include spi.h for definitions
//
#include "spi.h"

//
// Include avrlibc files
//
#include <avr/io.h>

//
// SPI initialization
//
void SPI_init(void)		// Set MOSI and SCK output, all others input
{
	SPCR |= ((1<<SPE)|(1<<MSTR)|(1<<SPR1));	//enable SPI, Master, clock rate fck/4
	SPSR |= (1<<SPI2X);						//2x speed, kokku SPI kell fck/32
}

//
// SPI write byte
//
void SPI_write(unsigned char data)
{
	SPDR = data;
	while (!(SPSR & 0x80));		// wait for data transfer to be completed
}