/*------------------------------------------------------------------------*/
/* Unicode - OEM code bidirectional converter  (C)ChaN, 2009              */
/*                                                                        */
/* CP932 (Japanese Shift-JIS)                                             */
/*------------------------------------------------------------------------*/
/*
/ AVRɏ悤ɕύXUnicodeϊW[łBSJISUnicodeϊ
/ e[uȗUnicodeSJISϊe[uCN^T[`
/ ĕϊĂ܂Bɂe[uTCYɂȂ܂BɁA
/ 񐅏R[h̑Ă܂Bɂ肳ɔɂȂĂ܂B
/ ͂ꂽOɍĕϊłȂR[hꍇAFR_INVALID_NAME
/ ƂȂAreaddir()ł͊Yt@CLFNƂȂ܂B
/
/ W[ETCY̓t@\ff.cƍ킹32KoCgxɎ܂̂ŁA
/ 64KȏAVRfoCXŎgpł܂B
*/

#ifdef __AVR_ATmega2561__

#include "module/ff.h"
#include <avr/pgmspace.h>

#if !_USE_LFN || _CODE_PAGE != 932
#error This file is not needed in current configuration.
#endif


static
const prog_uint16_t uni2sjis[] = {
/*  Unicode - Sjis, Unicode - Sjis, Unicode - Sjis, Unicode - Sjis, */
	0x00A7, 0x8198, 0x00A8, 0x814E, 0x00B0, 0x818B, 0x00B1, 0x817D,
	0x00B4, 0x814C, 0x00B6, 0x81F7, 0x00D7, 0x817E, 0x00F7, 0x8180,
	0x0391, 0x839F, 0x0392, 0x83A0, 0x0393, 0x83A1, 0x0394, 0x83A2,
	0x0395, 0x83A3, 0x0396, 0x83A4, 0x0397, 0x83A5, 0x0398, 0x83A6,
	0x0399, 0x83A7, 0x039A, 0x83A8, 0x039B, 0x83A9, 0x039C, 0x83AA,
	0x039D, 0x83AB, 0x039E, 0x83AC, 0x039F, 0x83AD, 0x03A0, 0x83AE,
	0x03A1, 0x83AF, 0x03A3, 0x83B0, 0x03A4, 0x83B1, 0x03A5, 0x83B2,
	0x03A6, 0x83B3, 0x03A7, 0x83B4, 0x03A8, 0x83B5, 0x03A9, 0x83B6,
	0x03B1, 0x83BF, 0x03B2, 0x83C0, 0x03B3, 0x83C1, 0x03B4, 0x83C2,
	0x03B5, 0x83C3, 0x03B6, 0x83C4, 0x03B7, 0x83C5, 0x03B8, 0x83C6,
	0x03B9, 0x83C7, 0x03BA, 0x83C8, 0x03BB, 0x83C9, 0x03BC, 0x83CA,
	0x03BD, 0x83CB, 0x03BE, 0x83CC, 0x03BF, 0x83CD, 0x03C0, 0x83CE,
	0x03C1, 0x83CF, 0x03C3, 0x83D0, 0x03C4, 0x83D1, 0x03C5, 0x83D2,
	0x03C6, 0x83D3, 0x03C7, 0x83D4, 0x03C8, 0x83D5, 0x03C9, 0x83D6,
	0x0401, 0x8446, 0x0410, 0x8440, 0x0411, 0x8441, 0x0412, 0x8442,
	0x0413, 0x8443, 0x0414, 0x8444, 0x0415, 0x8445, 0x0416, 0x8447,
	0x0417, 0x8448, 0x0418, 0x8449, 0x0419, 0x844A, 0x041A, 0x844B,
	0x041B, 0x844C, 0x041C, 0x844D, 0x041D, 0x844E, 0x041E, 0x844F,
	0x041F, 0x8450, 0x0420, 0x8451, 0x0421, 0x8452, 0x0422, 0x8453,
	0x0423, 0x8454, 0x0424, 0x8455, 0x0425, 0x8456, 0x0426, 0x8457,
	0x0427, 0x8458, 0x0428, 0x8459, 0x0429, 0x845A, 0x042A, 0x845B,
	0x042B, 0x845C, 0x042C, 0x845D, 0x042D, 0x845E, 0x042E, 0x845F,
	0x042F, 0x8460, 0x0430, 0x8470, 0x0431, 0x8471, 0x0432, 0x8472,
	0x0433, 0x8473, 0x0434, 0x8474, 0x0435, 0x8475, 0x0436, 0x8477,
	0x0437, 0x8478, 0x0438, 0x8479, 0x0439, 0x847A, 0x043A, 0x847B,
	0x043B, 0x847C, 0x043C, 0x847D, 0x043D, 0x847E, 0x043E, 0x8480,
	0x043F, 0x8481, 0x0440, 0x8482, 0x0441, 0x8483, 0x0442, 0x8484,
	0x0443, 0x8485, 0x0444, 0x8486, 0x0445, 0x8487, 0x0446, 0x8488,
	0x0447, 0x8489, 0x0448, 0x848A, 0x0449, 0x848B, 0x044A, 0x848C,
	0x044B, 0x848D, 0x044C, 0x848E, 0x044D, 0x848F, 0x044E, 0x8490,
	0x044F, 0x8491, 0x0451, 0x8476, 0x2010, 0x815D, 0x2015, 0x815C,
	0x2018, 0x8165, 0x2019, 0x8166, 0x201C, 0x8167, 0x201D, 0x8168,
	0x2020, 0x81F5, 0x2021, 0x81F6, 0x2025, 0x8164, 0x2026, 0x8163,
	0x2030, 0x81F1, 0x2032, 0x818C, 0x2033, 0x818D, 0x203B, 0x81A6,
	0x2103, 0x818E, 0x2116, 0x8782, 0x2121, 0x8784, 0x212B, 0x81F0,
	0x2160, 0x8754, 0x2161, 0x8755, 0x2162, 0x8756, 0x2163, 0x8757,
	0x2164, 0x8758, 0x2165, 0x8759, 0x2166, 0x875A, 0x2167, 0x875B,
	0x2168, 0x875C, 0x2169, 0x875D,
	0x2190, 0x81A9, 0x2191, 0x81AA, 0x2192, 0x81A8, 0x2193, 0x81AB,
	0x21D2, 0x81CB, 0x21D4, 0x81CC, 0x2200, 0x81CD, 0x2202, 0x81DD,
	0x2203, 0x81CE, 0x2207, 0x81DE, 0x2208, 0x81B8, 0x220B, 0x81B9,
	0x2211, 0x8794, 0x221A, 0x81E3, 0x221D, 0x81E5, 0x221E, 0x8187,
	0x221F, 0x8798, 0x2220, 0x81DA, 0x2225, 0x8161, 0x2227, 0x81C8,
	0x2228, 0x81C9, 0x2229, 0x81BF, 0x222A, 0x81BE, 0x222B, 0x81E7,
	0x222C, 0x81E8, 0x222E, 0x8793, 0x2234, 0x8188, 0x2235, 0x81E6,
	0x223D, 0x81E4, 0x2252, 0x81E0, 0x2260, 0x8182, 0x2261, 0x81DF,
	0x2266, 0x8185, 0x2267, 0x8186, 0x226A, 0x81E1, 0x226B, 0x81E2,
	0x2282, 0x81BC, 0x2283, 0x81BD, 0x2286, 0x81BA, 0x2287, 0x81BB,
	0x22A5, 0x81DB, 0x22BF, 0x8799, 0x2312, 0x81DC, 0x2460, 0x8740,
	0x2461, 0x8741, 0x2462, 0x8742, 0x2463, 0x8743, 0x2464, 0x8744,
	0x2465, 0x8745, 0x2466, 0x8746, 0x2467, 0x8747, 0x2468, 0x8748,
	0x2469, 0x8749, 0x246A, 0x874A, 0x246B, 0x874B, 0x246C, 0x874C,
	0x246D, 0x874D, 0x246E, 0x874E, 0x246F, 0x874F, 0x2470, 0x8750,
	0x2471, 0x8751, 0x2472, 0x8752, 0x2473, 0x8753, 0x2500, 0x849F,
	0x2501, 0x84AA, 0x2502, 0x84A0, 0x2503, 0x84AB, 0x250C, 0x84A1,
	0x250F, 0x84AC, 0x2510, 0x84A2, 0x2513, 0x84AD, 0x2514, 0x84A4,
	0x2517, 0x84AF, 0x2518, 0x84A3, 0x251B, 0x84AE, 0x251C, 0x84A5,
	0x251D, 0x84BA, 0x2520, 0x84B5, 0x2523, 0x84B0, 0x2524, 0x84A7,
	0x2525, 0x84BC, 0x2528, 0x84B7, 0x252B, 0x84B2, 0x252C, 0x84A6,
	0x252F, 0x84B6, 0x2530, 0x84BB, 0x2533, 0x84B1, 0x2534, 0x84A8,
	0x2537, 0x84B8, 0x2538, 0x84BD, 0x253B, 0x84B3, 0x253C, 0x84A9,
	0x253F, 0x84B9, 0x2542, 0x84BE, 0x254B, 0x84B4, 0x25A0, 0x81A1,
	0x25A1, 0x81A0, 0x25B2, 0x81A3, 0x25B3, 0x81A2, 0x25BC, 0x81A5,
	0x25BD, 0x81A4, 0x25C6, 0x819F, 0x25C7, 0x819E, 0x25CB, 0x819B,
	0x25CE, 0x819D, 0x25CF, 0x819C, 0x25EF, 0x81FC, 0x2605, 0x819A,
	0x2606, 0x8199, 0x2640, 0x818A, 0x2642, 0x8189, 0x266A, 0x81F4,
	0x266D, 0x81F3, 0x266F, 0x81F2, 0x3000, 0x8140, 0x3001, 0x8141,
	0x3002, 0x8142, 0x3003, 0x8156, 0x3005, 0x8158, 0x3006, 0x8159,
	0x3007, 0x815A, 0x3008, 0x8171, 0x3009, 0x8172, 0x300A, 0x8173,
	0x300B, 0x8174, 0x300C, 0x8175, 0x300D, 0x8176, 0x300E, 0x8177,
	0x300F, 0x8178, 0x3010, 0x8179, 0x3011, 0x817A, 0x3012, 0x81A7,
	0x3013, 0x81AC, 0x3014, 0x816B, 0x3015, 0x816C, 0x301D, 0x8780,
	0x301F, 0x8781, 0x3041, 0x829F, 0x3042, 0x82A0, 0x3043, 0x82A1,
	0x3044, 0x82A2, 0x3045, 0x82A3, 0x3046, 0x82A4, 0x3047, 0x82A5,
	0x3048, 0x82A6, 0x3049, 0x82A7, 0x304A, 0x82A8, 0x304B, 0x82A9,
	0x304C, 0x82AA, 0x304D, 0x82AB, 0x304E, 0x82AC, 0x304F, 0x82AD,
	0x3050, 0x82AE, 0x3051, 0x82AF, 0x3052, 0x82B0, 0x3053, 0x82B1,
	0x3054, 0x82B2, 0x3055, 0x82B3, 0x3056, 0x82B4, 0x3057, 0x82B5,
	0x3058, 0x82B6, 0x3059, 0x82B7, 0x305A, 0x82B8, 0x305B, 0x82B9,
	0x305C, 0x82BA, 0x305D, 0x82BB, 0x305E, 0x82BC, 0x305F, 0x82BD,
	0x3060, 0x82BE, 0x3061, 0x82BF, 0x3062, 0x82C0, 0x3063, 0x82C1,
	0x3064, 0x82C2, 0x3065, 0x82C3, 0x3066, 0x82C4, 0x3067, 0x82C5,
	0x3068, 0x82C6, 0x3069, 0x82C7, 0x306A, 0x82C8, 0x306B, 0x82C9,
	0x306C, 0x82CA, 0x306D, 0x82CB, 0x306E, 0x82CC, 0x306F, 0x82CD,
	0x3070, 0x82CE, 0x3071, 0x82CF, 0x3072, 0x82D0, 0x3073, 0x82D1,
	0x3074, 0x82D2, 0x3075, 0x82D3, 0x3076, 0x82D4, 0x3077, 0x82D5,
	0x3078, 0x82D6, 0x3079, 0x82D7, 0x307A, 0x82D8, 0x307B, 0x82D9,
	0x307C, 0x82DA, 0x307D, 0x82DB, 0x307E, 0x82DC, 0x307F, 0x82DD,
	0x3080, 0x82DE, 0x3081, 0x82DF, 0x3082, 0x82E0, 0x3083, 0x82E1,
	0x3084, 0x82E2, 0x3085, 0x82E3, 0x3086, 0x82E4, 0x3087, 0x82E5,
	0x3088, 0x82E6, 0x3089, 0x82E7, 0x308A, 0x82E8, 0x308B, 0x82E9,
	0x308C, 0x82EA, 0x308D, 0x82EB, 0x308E, 0x82EC, 0x308F, 0x82ED,
	0x3090, 0x82EE, 0x3091, 0x82EF, 0x3092, 0x82F0, 0x3093, 0x82F1,
	0x309B, 0x814A, 0x309C, 0x814B, 0x309D, 0x8154,
	0x309E, 0x8155, 0x30A1, 0x8340, 0x30A2, 0x8341, 0x30A3, 0x8342,
	0x30A4, 0x8343, 0x30A5, 0x8344, 0x30A6, 0x8345, 0x30A7, 0x8346,
	0x30A8, 0x8347, 0x30A9, 0x8348, 0x30AA, 0x8349, 0x30AB, 0x834A,
	0x30AC, 0x834B, 0x30AD, 0x834C, 0x30AE, 0x834D, 0x30AF, 0x834E,
	0x30B0, 0x834F, 0x30B1, 0x8350, 0x30B2, 0x8351, 0x30B3, 0x8352,
	0x30B4, 0x8353, 0x30B5, 0x8354, 0x30B6, 0x8355, 0x30B7, 0x8356,
	0x30B8, 0x8357, 0x30B9, 0x8358, 0x30BA, 0x8359, 0x30BB, 0x835A,
	0x30BC, 0x835B, 0x30BD, 0x835C, 0x30BE, 0x835D, 0x30BF, 0x835E,
	0x30C0, 0x835F, 0x30C1, 0x8360, 0x30C2, 0x8361, 0x30C3, 0x8362,
	0x30C4, 0x8363, 0x30C5, 0x8364, 0x30C6, 0x8365, 0x30C7, 0x8366,
	0x30C8, 0x8367, 0x30C9, 0x8368, 0x30CA, 0x8369, 0x30CB, 0x836A,
	0x30CC, 0x836B, 0x30CD, 0x836C, 0x30CE, 0x836D, 0x30CF, 0x836E,
	0x30D0, 0x836F, 0x30D1, 0x8370, 0x30D2, 0x8371, 0x30D3, 0x8372,
	0x30D4, 0x8373, 0x30D5, 0x8374, 0x30D6, 0x8375, 0x30D7, 0x8376,
	0x30D8, 0x8377, 0x30D9, 0x8378, 0x30DA, 0x8379, 0x30DB, 0x837A,
	0x30DC, 0x837B, 0x30DD, 0x837C, 0x30DE, 0x837D, 0x30DF, 0x837E,
	0x30E0, 0x8380, 0x30E1, 0x8381, 0x30E2, 0x8382, 0x30E3, 0x8383,
	0x30E4, 0x8384, 0x30E5, 0x8385, 0x30E6, 0x8386, 0x30E7, 0x8387,
	0x30E8, 0x8388, 0x30E9, 0x8389, 0x30EA, 0x838A, 0x30EB, 0x838B,
	0x30EC, 0x838C, 0x30ED, 0x838D, 0x30EE, 0x838E, 0x30EF, 0x838F,
	0x30F0, 0x8390, 0x30F1, 0x8391, 0x30F2, 0x8392, 0x30F3, 0x8393,
	0x30F4, 0x8394, 0x30F5, 0x8395, 0x30F6, 0x8396, 0x30FB, 0x8145,
	0x30FC, 0x815B, 0x30FD, 0x8152, 0x30FE, 0x8153, 0x3231, 0x878A,
	0x3232, 0x878B, 0x3239, 0x878C, 0x32A4, 0x8785, 0x32A5, 0x8786,
	0x32A6, 0x8787, 0x32A7, 0x8788, 0x32A8, 0x8789, 0x3303, 0x8765,
	0x330D, 0x8769, 0x3314, 0x8760, 0x3318, 0x8763, 0x3322, 0x8761,
	0x3323, 0x876B, 0x3326, 0x876A, 0x3327, 0x8764, 0x332B, 0x876C,
	0x3336, 0x8766, 0x333B, 0x876E, 0x3349, 0x875F, 0x334A, 0x876D,
	0x334D, 0x8762, 0x3351, 0x8767, 0x3357, 0x8768, 0x337B, 0x877E,
	0x337C, 0x878F, 0x337D, 0x878E, 0x337E, 0x878D, 0x338E, 0x8772,
	0x338F, 0x8773, 0x339C, 0x876F, 0x339D, 0x8770, 0x339E, 0x8771,
	0x33A1, 0x8775, 0x33C4, 0x8774, 0x33CD, 0x8783, 0x4E00, 0x88EA,
	0x4E01, 0x929A, 0x4E03, 0x8EB5, 0x4E07, 0x969C, 0x4E08, 0x8FE4,
	0x4E09, 0x8E4F, 0x4E0A, 0x8FE3, 0x4E0B, 0x89BA, 0x4E0D, 0x9573,
	0x4E0E, 0x975E, 0x4E11, 0x894E, 0x4E14, 0x8A8E,
	0x4E15, 0x98A1, 0x4E16, 0x90A2, 0x4E18, 0x8B75,
	0x4E19, 0x95B8, 0x4E1E, 0x8FE5, 0x4E21, 0x97BC, 0x4E26, 0x95C0,
	0x4E2A, 0x98A2, 0x4E2D, 0x9286,
	0x4E32, 0x8BF8, 0x4E38, 0x8ADB, 0x4E39, 0x924F,
	0x4E3B, 0x8EE5, 0x4E3C, 0x98A5,
	0x4E43, 0x9454, 0x4E45, 0x8B76, 0x4E4B, 0x9456, 0x4E4D, 0x93E1,
	0x4E4E, 0x8CC1, 0x4E4F, 0x9652, 0x4E56, 0x98A8,
	0x4E57, 0x8FE6, 0x4E59, 0x89B3, 0x4E5D, 0x8BE3,
	0x4E5E, 0x8CEE, 0x4E5F, 0x96E7, 0x4E71, 0x9790,
	0x4E73, 0x93FB, 0x4E7E, 0x8AA3, 0x4E80, 0x8B54,
	0x4E86, 0x97B9, 0x4E88, 0x975C, 0x4E89, 0x9188,
	0x4E8B, 0x8E96, 0x4E8C, 0x93F1, 0x4E8E, 0x98B0,
	0x4E91, 0x895D, 0x4E92, 0x8CDD, 0x4E94, 0x8CDC, 0x4E95, 0x88E4,
	0x4E98, 0x986A, 0x4E99, 0x9869, 0x4E9B, 0x8DB1, 0x4E9C, 0x889F,
	0x4E9E, 0x98B1, 0x4EA1, 0x9653,
	0x4EA4, 0x8CF0, 0x4EA5, 0x88E5, 0x4EA6, 0x9692,
	0x4EA8, 0x8B9C, 0x4EAB, 0x8B9D, 0x4EAC, 0x8B9E, 0x4EAD, 0x92E0,
	0x4EAE, 0x97BA,
	0x4EBA, 0x906C, 0x4EC0, 0x8F59, 0x4EC1, 0x906D,
	0x4EC7, 0x8B77, 0x4ECA, 0x8DA1,
	0x4ECB, 0x89EE, 0x4ECF, 0x95A7,
	0x4ED4, 0x8E65, 0x4ED5, 0x8E64, 0x4ED6, 0x91BC,
	0x4ED8, 0x9574, 0x4ED9, 0x90E5, 0x4EDD, 0x8157,
	0x4EE3, 0x91E3, 0x4EE4, 0x97DF,
	0x4EE5, 0x88C8, 0x4EEE, 0x89BC, 0x4EF0, 0x8BC2,
	0x4EF2, 0x9287, 0x4EF6, 0x8C8F, 0x4EFB, 0x9443,
	0x4F01, 0x8AE9,
	0x4F0A, 0x88C9, 0x4F0D, 0x8CDE, 0x4F0E, 0x8AEA,
	0x4F0F, 0x959A, 0x4F10, 0x94B0, 0x4F11, 0x8B78, 0x4F1A, 0x89EF,
	0x4F1D, 0x9360, 0x4F2F, 0x948C,
	0x4F34, 0x94BA, 0x4F36, 0x97E0, 0x4F38, 0x904C,
	0x4F3A, 0x8E66, 0x4F3C, 0x8E97, 0x4F3D, 0x89BE, 0x4F43, 0x92CF,
	0x4F46, 0x9241, 0x4F47, 0x98C8, 0x4F4D, 0x88CA, 0x4F4E, 0x92E1,
	0x4F4F, 0x8F5A, 0x4F50, 0x8DB2, 0x4F51, 0x9743, 0x4F53, 0x91CC,
	0x4F55, 0x89BD, 0x4F57, 0x98C7, 0x4F59, 0x975D,
	0x4F5B, 0x98C5, 0x4F5C, 0x8DEC,
	0x4F73, 0x89C0, 0x4F75, 0x95B9,
	0x4F7C, 0x8CF1, 0x4F7F, 0x8E67, 0x4F83, 0x8AA4, 0x4F86, 0x98D2,
	0x4F8B, 0x97E1, 0x4F8D, 0x8E98,
	0x4F9B, 0x8B9F,
	0x4F9D, 0x88CB, 0x4FA0, 0x8BA0, 0x4FA1, 0x89BF,
	0x4FAD, 0x9699, 0x4FAE, 0x958E, 0x4FAF, 0x8CF2, 0x4FB5, 0x904E,
	0x4FB6, 0x97B5, 0x4FBF, 0x95D6, 0x4FC2, 0x8C57, 0x4FC3, 0x91A3,
	0x4FC4, 0x89E2, 0x4FCA, 0x8F72,
	0x4FD7, 0x91AD,
	0x4FDD, 0x95DB, 0x4FE1, 0x904D, 0x4FE3, 0x9693,
	0x4FEE, 0x8F43,
	0x4FF3, 0x946F, 0x4FF5, 0x9555, 0x4FF8, 0x95EE,
	0x4FFA, 0x89B4,
	0x5009, 0x9171, 0x500B, 0x8CC2, 0x500D, 0x947B,
	0x5012, 0x937C,
	0x5016, 0x8CF4, 0x5019, 0x8CF3,
	0x501F, 0x8ED8, 0x5023, 0x95ED,
	0x5024, 0x926C, 0x5026, 0x8C91,
	0x502B, 0x97CF,
	0x502D, 0x9860, 0x5036, 0x8BE4, 0x5039, 0x8C90,
	0x5049, 0x88CC, 0x504F, 0x95CE,
	0x5055, 0x98F1, 0x505C, 0x92E2,
	0x5065, 0x8C92, 0x5072, 0x8EC3,
	0x5074, 0x91A4, 0x5075, 0x92E3, 0x5076, 0x8BF4,
	0x507D, 0x8B55, 0x508D, 0x9654,
	0x5091, 0x8C86, 0x5098, 0x8E50, 0x5099, 0x94F5,
	0x50AC, 0x8DC3, 0x50AD, 0x9762,
	0x50B5, 0x8DC2, 0x50B7, 0x8F9D,
	0x50BE, 0x8C58, 0x50C5, 0x8BCD,
	0x50CD, 0x93AD, 0x50CF, 0x919C, 0x50D1, 0x8BA1,
	0x50D5, 0x966C, 0x50DA, 0x97BB,
	0x50E7, 0x916D,
	0x50FB, 0x95C6, 0x5100, 0x8B56,
	0x5104, 0x89AD, 0x5112, 0x8EF2,
	0x511A, 0x9952, 0x511F, 0x8F9E, 0x512A, 0x9744,
	0x5132, 0x96D7,
	0x5141, 0x88F2,
	0x5143, 0x8CB3, 0x5144, 0x8C5A, 0x5145, 0x8F5B, 0x5146, 0x929B,
	0x5147, 0x8BA2, 0x5148, 0x90E6, 0x5149, 0x8CF5,
	0x514B, 0x8D8E, 0x514C, 0x995B, 0x514D, 0x96C6, 0x514E, 0x9365,
	0x5150, 0x8E99, 0x5152, 0x995A, 0x5154, 0x995C, 0x515A, 0x937D,
	0x515C, 0x8A95, 0x5165, 0x93FC,
	0x5168, 0x9153, 0x516B, 0x94AA,
	0x516C, 0x8CF6, 0x516D, 0x985A, 0x5171, 0x8BA4,
	0x5175, 0x95BA, 0x5176, 0x91B4, 0x5177, 0x8BEF, 0x5178, 0x9354,
	0x517C, 0x8C93, 0x5185, 0x93E0,
	0x5186, 0x897E, 0x518A, 0x8DFB,
	0x518D, 0x8DC4, 0x5191, 0x9968,
	0x5192, 0x9660,
	0x5197, 0x8FE7, 0x5199, 0x8ECA, 0x51A0, 0x8AA5,
	0x51A4, 0x996C, 0x51A5, 0x96BB,
	0x51A8, 0x9579,
	0x51AC, 0x937E,
	0x51B4, 0x8DE1, 0x51B6, 0x96E8,
	0x51B7, 0x97E2, 0x51C4, 0x90A6,
	0x51C6, 0x8F79, 0x51CB, 0x929C,
	0x51CC, 0x97BD, 0x51CD, 0x9380,
	0x51DC, 0xEAA3, 0x51DD, 0x8BC3, 0x51E0, 0x997B, 0x51E1, 0x967D,
	0x51E6, 0x8F88, 0x51E7, 0x91FA, 0x51EA, 0x93E2,
	0x51F1, 0x8A4D,
	0x51F6, 0x8BA5, 0x51F8, 0x93CA, 0x51F9, 0x899A,
	0x51FA, 0x8F6F, 0x51FD, 0x949F, 0x5200, 0x9381,
	0x5203, 0x906E, 0x5206, 0x95AA, 0x5207, 0x90D8,
	0x5208, 0x8AA0, 0x520A, 0x8AA7,
	0x5211, 0x8C59, 0x5217, 0x97F1,
	0x521D, 0x8F89, 0x5224, 0x94BB, 0x5225, 0x95CA,
	0x5229, 0x9798, 0x5230, 0x939E,
	0x5236, 0x90A7, 0x5237, 0x8DFC, 0x5238, 0x8C94,
	0x5239, 0x998B, 0x523A, 0x8E68, 0x523B, 0x8D8F, 0x5243, 0x92E4,
	0x5247, 0x91A5, 0x524A, 0x8DED,
	0x524D, 0x914F,
	0x5256, 0x9655, 0x525B, 0x8D84, 0x5263, 0x8C95,
	0x5264, 0x8DDC, 0x5265, 0x948D, 0x526A, 0x9992,
	0x526F, 0x959B, 0x5270, 0x8FE8, 0x5272, 0x8A84,
	0x5274, 0x9993, 0x5275, 0x916E,
	0x5283, 0x8A63, 0x5287, 0x8C80, 0x5288, 0x999C,
	0x5289, 0x97AB,
	0x529B, 0x97CD, 0x529F, 0x8CF7,
	0x52A0, 0x89C1, 0x52A3, 0x97F2, 0x52A9, 0x8F95,
	0x52AA, 0x9377, 0x52AB, 0x8D85,
	0x52B1, 0x97E3, 0x52B4, 0x984A,
	0x52B9, 0x8CF8, 0x52BE, 0x8A4E,
	0x52C3, 0x9675, 0x52C5, 0x92BA, 0x52C7, 0x9745,
	0x52C9, 0x95D7, 0x52D5, 0x93AE,
	0x52D8, 0x8AA8, 0x52D9, 0x96B1,
	0x52DD, 0x8F9F, 0x52DF, 0x95E5,
	0x52E2, 0x90A8, 0x52E4, 0x8BCE,
	0x52E7, 0x8AA9, 0x52F2, 0x8C4D,
	0x52FA, 0x8ED9, 0x52FE, 0x8CF9,
	0x52FF, 0x96DC, 0x5301, 0x96E6, 0x5302, 0x93F5,
	0x5305, 0x95EF,
	0x5316, 0x89BB, 0x5317, 0x966B, 0x5319, 0x8DFA,
	0x531D, 0x9178, 0x5320, 0x8FA0, 0x5321, 0x8BA7,
	0x532A, 0x94D9,
	0x5339, 0x9543, 0x533A, 0x8BE6,
	0x533B, 0x88E3, 0x533F, 0x93BD, 0x5340, 0x99BD, 0x5341, 0x8F5C,
	0x5343, 0x90E7, 0x5347, 0x8FA1,
	0x5348, 0x8CDF, 0x534A, 0x94BC, 0x534D, 0x99C2,
	0x5351, 0x94DA, 0x5352, 0x91B2, 0x5353, 0x91EC, 0x5354, 0x8BA6,
	0x5357, 0x93EC, 0x5358, 0x9250, 0x535A, 0x948E, 0x535C, 0x966D,
	0x5360, 0x90E8, 0x5366, 0x8C54,
	0x536F, 0x894B, 0x5370, 0x88F3, 0x5371, 0x8AEB,
	0x5373, 0x91A6, 0x5374, 0x8B70, 0x5375, 0x9791,
	0x5378, 0x89B5, 0x537F, 0x8BA8,
	0x5382, 0x99CA, 0x5384, 0x96EF,
	0x5398, 0x97D0, 0x539A, 0x8CFA, 0x539F, 0x8CB4, 0x53A0, 0x99CC,
	0x53A8, 0x907E, 0x53A9, 0x8958,
	0x53AD, 0x897D,
	0x53B3, 0x8CB5, 0x53BB, 0x8B8E, 0x53C2, 0x8E51,
	0x53C8, 0x9694, 0x53C9, 0x8DB3, 0x53CA, 0x8B79,
	0x53CB, 0x9746, 0x53CC, 0x916F, 0x53CD, 0x94BD, 0x53CE, 0x8EFB,
	0x53D4, 0x8F66, 0x53D6, 0x8EE6, 0x53D7, 0x8EF3, 0x53D9, 0x8F96,
	0x53DB, 0x94BE, 0x53E1, 0x8962,
	0x53E2, 0x9170, 0x53E3, 0x8CFB, 0x53E4, 0x8CC3, 0x53E5, 0x8BE5,
	0x53E9, 0x9240, 0x53EA, 0x91FC, 0x53EB, 0x8BA9,
	0x53EC, 0x8FA2, 0x53EF, 0x89C2,
	0x53F0, 0x91E4, 0x53F1, 0x8EB6, 0x53F2, 0x8E6A, 0x53F3, 0x8945,
	0x53F6, 0x8A90, 0x53F7, 0x8D86, 0x53F8, 0x8E69,
	0x5403, 0x8B68, 0x5404, 0x8A65, 0x5408, 0x8D87,
	0x5409, 0x8B67, 0x540A, 0x92DD, 0x540B, 0x8944, 0x540C, 0x93AF,
	0x540D, 0x96BC, 0x540E, 0x8D40, 0x540F, 0x9799, 0x5410, 0x9366,
	0x5411, 0x8CFC, 0x541B, 0x8C4E, 0x541F, 0x8BE1,
	0x5420, 0x9669, 0x5426, 0x94DB, 0x542B, 0x8ADC,
	0x5438, 0x8B7A, 0x5439, 0x9081, 0x543B, 0x95AB,
	0x543E, 0x8CE1, 0x5442, 0x9843,
	0x5446, 0x95F0, 0x5448, 0x92E6, 0x5449, 0x8CE0, 0x544A, 0x8D90,
	0x5451, 0x93DB, 0x5468, 0x8EFC,
	0x546A, 0x8EF4, 0x5473, 0x96A1,
	0x547B, 0x99EF,
	0x547C, 0x8CC4, 0x547D, 0x96BD, 0x5480, 0x99F0,
	0x548B, 0x8DEE, 0x548C, 0x9861,
	0x548E, 0x99E9,
	0x54AC, 0x99F9,
	0x54B2, 0x8DE7, 0x54B3, 0x8A50,
	0x54BD, 0x88F4, 0x54C0, 0x88A3,
	0x54C1, 0x9569,
	0x54C9, 0x8DC6, 0x54E1, 0x88F5,
	0x54E8, 0x8FA3,
	0x54E9, 0x9689, 0x54F2, 0x934E,
	0x5504, 0x8953,
	0x5506, 0x8DB4, 0x5507, 0x904F, 0x5510, 0x9382,
	0x5516, 0x88A0, 0x552F, 0x9742,
	0x5531, 0x8FA5,
	0x553E, 0x91C1, 0x5544, 0x91ED,
	0x5546, 0x8FA4, 0x554F, 0x96E2, 0x5553, 0x8C5B,
	0x5584, 0x9150,
	0x5589, 0x8D41, 0x558B, 0x929D,
	0x5598, 0x9A62, 0x559A, 0x8AAB, 0x559C, 0x8AEC,
	0x559D, 0x8A85, 0x55A7, 0x8C96,
	0x55AA, 0x9172, 0x55AB, 0x8B69,
	0x55AC, 0x8BAA, 0x55AE, 0x9A64, 0x55B0, 0x8BF2, 0x55B6, 0x8963,
	0x55E3, 0x8E6B,
	0x5606, 0x9251, 0x5609, 0x89C3, 0x5614, 0x9A71,
	0x5617, 0x8FA6, 0x5618, 0x8952,
	0x5629, 0x89DC, 0x5631, 0x8FFA,
	0x5642, 0x895C,
	0x564C, 0x9158, 0x565B, 0x8A9A,
	0x5668, 0x8AED,
	0x5674, 0x95AC, 0x5678, 0x93D3, 0x567A, 0x94B6,
	0x5687, 0x8A64,
	0x56A2, 0x9458,
	0x56C0, 0x9A93, 0x56C1, 0x9A91,
	0x56C3, 0x9A92,
	0x56D3, 0x9A97, 0x56DA, 0x8EFA,
	0x56DB, 0x8E6C, 0x56DE, 0x89F1, 0x56E0, 0x88F6, 0x56E3, 0x9263,
	0x56EE, 0x9A99, 0x56F0, 0x8DA2, 0x56F2, 0x88CD, 0x56F3, 0x907D,
	0x56FA, 0x8CC5, 0x56FD, 0x8D91,
	0x5703, 0x95DE,
	0x570B, 0x9AA0, 0x570F, 0x8C97,
	0x5712, 0x8980, 0x5713, 0x9AA2,
	0x571F, 0x9379, 0x5727, 0x88B3,
	0x5728, 0x8DDD, 0x572D, 0x8C5C, 0x5730, 0x926E,
	0x5742, 0x8DE2,
	0x5747, 0x8BCF, 0x574A, 0x9656,
	0x5750, 0x8DBF, 0x5751, 0x8D42,
	0x5764, 0x8DA3, 0x5766, 0x9252,
	0x576A, 0x92D8, 0x5782, 0x9082,
	0x578B, 0x8C5E,
	0x57A2, 0x8D43, 0x57A3, 0x8A5F,
	0x57C3, 0x9ABA,
	0x57CB, 0x9684, 0x57CE, 0x8FE9,
	0x57DC, 0x9457, 0x57DF, 0x88E6,
	0x57E0, 0x9575, 0x57F4, 0x8FFB, 0x57F7, 0x8EB7,
	0x57F9, 0x947C, 0x57FA, 0x8AEE, 0x57FC, 0x8DE9, 0x5800, 0x9678,
	0x5802, 0x93B0, 0x5805, 0x8C98, 0x5806, 0x91CD,
	0x5815, 0x91C2,
	0x5821, 0x9AC6, 0x5824, 0x92E7, 0x582A, 0x8AAC,
	0x5830, 0x8981, 0x5831, 0x95F1, 0x5834, 0x8FEA, 0x5835, 0x9367,
	0x583A, 0x8DE4, 0x5840, 0x95BB, 0x5841, 0x97DB,
	0x584A, 0x89F2, 0x5851, 0x9159,
	0x5854, 0x9383, 0x5857, 0x9368, 0x5858, 0x9384, 0x5859, 0x94B7,
	0x585A, 0x92CB, 0x585E, 0x8DC7, 0x5869, 0x8996,
	0x586B, 0x9355, 0x5875, 0x906F,
	0x5879, 0x9ACD, 0x587E, 0x8F6D, 0x5883, 0x8BAB,
	0x5893, 0x95E6, 0x5897, 0x919D, 0x589C, 0x92C4,
	0x589F, 0x9AD0, 0x58A8, 0x966E,
	0x58B3, 0x95AD,
	0x58BE, 0x8DA4, 0x58C1, 0x95C7,
	0x58C7, 0x9264, 0x58CA, 0x89F3, 0x58CC, 0x8FEB,
	0x58D5, 0x8D88,
	0x58EB, 0x8E6D,
	0x58EC, 0x9070, 0x58EE, 0x9173, 0x58F0, 0x90BA,
	0x58F1, 0x88EB, 0x58F2, 0x9484, 0x58F7, 0x92D9,
	0x5909, 0x95CF,
	0x590F, 0x89C4, 0x5915, 0x975B, 0x5916, 0x8A4F,
	0x5919, 0x8F67, 0x591A, 0x91BD,
	0x591C, 0x96E9, 0x5922, 0x96B2, 0x5927, 0x91E5,
	0x5929, 0x9356, 0x592A, 0x91BE, 0x592B, 0x9576,
	0x592E, 0x899B, 0x5931, 0x8EB8,
	0x5937, 0x88CE, 0x5944, 0x8982,
	0x5947, 0x8AEF, 0x5948, 0x93DE, 0x5949, 0x95F2,
	0x594F, 0x9174, 0x5951, 0x8C5F,
	0x5954, 0x967A, 0x5957, 0x9385,
	0x5965, 0x899C,
	0x5968, 0x8FA7, 0x596A, 0x9244,
	0x596E, 0x95B1, 0x5973, 0x8F97, 0x5974, 0x937A,
	0x597D, 0x8D44, 0x5982, 0x9440, 0x5983, 0x94DC,
	0x5984, 0x96CF, 0x598A, 0x9444, 0x5993, 0x8B57,
	0x5996, 0x9764, 0x5999, 0x96AD,
	0x59A5, 0x91C3, 0x59A8, 0x9657,
	0x59AC, 0x9369, 0x59B9, 0x9685,
	0x59BB, 0x8DC8, 0x59BE, 0x8FA8, 0x59C9, 0x8E6F,
	0x59CB, 0x8E6E, 0x59D0, 0x88B7, 0x59D1, 0x8CC6, 0x59D3, 0x90A9,
	0x59D4, 0x88CF,
	0x59E5, 0x8957, 0x59E6, 0x8AAD, 0x59EA, 0x96C3,
	0x59EB, 0x9550, 0x59F6, 0x88A6, 0x59FB, 0x88F7, 0x59FF, 0x8E70,
	0x5A01, 0x88D0, 0x5A03, 0x88A1,
	0x5A18, 0x96BA,
	0x5A20, 0x9050, 0x5A29, 0x95D8, 0x5A2F, 0x8CE2,
	0x5A3C, 0x8FA9,
	0x5A41, 0x984B, 0x5A46, 0x946B, 0x5A5A, 0x8DA5,
	0x5A66, 0x9577,
	0x5A7F, 0x96B9, 0x5A92, 0x947D, 0x5A9B, 0x9551,
	0x5AC1, 0x89C5,
	0x5AC9, 0x8EB9, 0x5ACC, 0x8C99,
	0x5AE1, 0x9284,
	0x5B09, 0x8AF0,
	0x5B22, 0x8FEC, 0x5B2C, 0x92DA,
	0x5B30, 0x8964,
	0x5B50, 0x8E71,
	0x5B54, 0x8D45,
	0x5B57, 0x8E9A, 0x5B58, 0x91B6,
	0x5B5C, 0x8E79, 0x5B5D, 0x8D46, 0x5B5F, 0x96D0, 0x5B63, 0x8B47,
	0x5B64, 0x8CC7, 0x5B66, 0x8A77,
	0x5B6B, 0x91B7,
	0x5B78, 0x9B7B,
	0x5B85, 0x91EE, 0x5B87, 0x8946, 0x5B88, 0x8EE7,
	0x5B89, 0x88C0, 0x5B8B, 0x9176, 0x5B8C, 0x8AAE, 0x5B8D, 0x8EB3,
	0x5B8F, 0x8D47, 0x5B95, 0x9386, 0x5B97, 0x8F40, 0x5B98, 0x8AAF,
	0x5B99, 0x9288, 0x5B9A, 0x92E8, 0x5B9B, 0x88B6, 0x5B9C, 0x8B58,
	0x5B9D, 0x95F3, 0x5B9F, 0x8EC0, 0x5BA2, 0x8B71, 0x5BA3, 0x90E9,
	0x5BA4, 0x8EBA, 0x5BA5, 0x9747, 0x5BAE, 0x8B7B,
	0x5BB0, 0x8DC9, 0x5BB3, 0x8A51, 0x5BB4, 0x8983, 0x5BB5, 0x8FAA,
	0x5BB6, 0x89C6, 0x5BB9, 0x9765, 0x5BBF, 0x8F68,
	0x5BC2, 0x8EE2, 0x5BC4, 0x8AF1,
	0x5BC5, 0x93D0, 0x5BC6, 0x96A7,
	0x5BCC, 0x9578, 0x5BD2, 0x8AA6, 0x5BD3, 0x8BF5,
	0x5BDB, 0x8AB0, 0x5BDD, 0x9051,
	0x5BDF, 0x8E40, 0x5BE1, 0x89C7,
	0x5BE7, 0x944A,
	0x5BE9, 0x9052,
	0x5BEE, 0x97BE, 0x5BF5, 0x929E,
	0x5BF8, 0x90A1, 0x5BFA, 0x8E9B, 0x5BFE, 0x91CE,
	0x5BFF, 0x8EF5, 0x5C01, 0x9595, 0x5C02, 0x90EA, 0x5C04, 0x8ECB,
	0x5C06, 0x8FAB,
	0x5C09, 0x88D1, 0x5C0A, 0x91B8, 0x5C0B, 0x9071,
	0x5C0E, 0x93B1, 0x5C0F, 0x8FAC, 0x5C11, 0x8FAD,
	0x5C16, 0x90EB, 0x5C1A, 0x8FAE,
	0x5C24, 0x96DE, 0x5C2D, 0x8BC4,
	0x5C31, 0x8F41, 0x5C3A, 0x8EDA,
	0x5C3B, 0x904B, 0x5C3C, 0x93F2, 0x5C3D, 0x9073, 0x5C3E, 0x94F6,
	0x5C3F, 0x9441, 0x5C40, 0x8BC7, 0x5C41, 0x9B9B, 0x5C45, 0x8B8F,
	0x5C48, 0x8BFC, 0x5C4A, 0x93CD, 0x5C4B, 0x89AE,
	0x5C4D, 0x8E72,
	0x5C51, 0x8BFB, 0x5C55, 0x9357, 0x5C5E, 0x91AE,
	0x5C60, 0x936A, 0x5C61, 0x8EC6, 0x5C64, 0x9177, 0x5C65, 0x979A,
	0x5C6F, 0x93D4, 0x5C71, 0x8E52,
	0x5C79, 0x9BA6, 0x5C90, 0x8AF2,
	0x5CA1, 0x89AA,
	0x5CA8, 0x915A, 0x5CA9, 0x8AE2, 0x5CAC, 0x96A6,
	0x5CB1, 0x91D0, 0x5CB3, 0x8A78,
	0x5CB8, 0x8ADD,
	0x5CE0, 0x93BB, 0x5CE1, 0x8BAC, 0x5CE8, 0x89E3,
	0x5CEF, 0x95F5, 0x5CF0, 0x95F4,
	0x5CF6, 0x9387, 0x5CFB, 0x8F73,
	0x5D07, 0x9092, 0x5D0E, 0x8DE8,
	0x5D16, 0x8A52,
	0x5D29, 0x95F6,
	0x5D50, 0x9792,
	0x5D69, 0x9093,
	0x5D6F, 0x8DB5,
	0x5D8B, 0x9388,
	0x5DBA, 0x97E4,
	0x5DCC, 0x8ADE,
	0x5DDD, 0x90EC,
	0x5DDE, 0x8F42, 0x5DE1, 0x8F84, 0x5DE3, 0x9183, 0x5DE5, 0x8D48,
	0x5DE6, 0x8DB6, 0x5DE7, 0x8D49, 0x5DE8, 0x8B90, 0x5DEB, 0x9BDE,
	0x5DEE, 0x8DB7, 0x5DF1, 0x8CC8, 0x5DF3, 0x96A4,
	0x5DF4, 0x9462, 0x5DF7, 0x8D4A, 0x5DFB, 0x8AAA,
	0x5DFD, 0x9246, 0x5DFE, 0x8BD0, 0x5E02, 0x8E73, 0x5E03, 0x957A,
	0x5E06, 0x94BF, 0x5E0C, 0x8AF3,
	0x5E16, 0x929F,
	0x5E1D, 0x92E9, 0x5E25, 0x9083, 0x5E2B, 0x8E74, 0x5E2D, 0x90C8,
	0x5E2F, 0x91D1, 0x5E30, 0x8B41, 0x5E33, 0x92A0,
	0x5E38, 0x8FED, 0x5E3D, 0x9658,
	0x5E45, 0x959D,
	0x5E4C, 0x9679, 0x5E55, 0x968B,
	0x5E61, 0x94A6,
	0x5E63, 0x95BC, 0x5E72, 0x8AB1, 0x5E73, 0x95BD,
	0x5E74, 0x944E, 0x5E78, 0x8D4B,
	0x5E79, 0x8AB2, 0x5E7B, 0x8CB6, 0x5E7C, 0x9763,
	0x5E7D, 0x9748, 0x5E7E, 0x8AF4, 0x5E81, 0x92A1,
	0x5E83, 0x8D4C, 0x5E84, 0x8FAF, 0x5E87, 0x94DD, 0x5E8A, 0x8FB0,
	0x5E8F, 0x8F98, 0x5E95, 0x92EA, 0x5E96, 0x95F7, 0x5E97, 0x9358,
	0x5E9A, 0x8D4D, 0x5E9C, 0x957B, 0x5EA6, 0x9378,
	0x5EA7, 0x8DC0, 0x5EAB, 0x8CC9, 0x5EAD, 0x92EB, 0x5EB5, 0x88C1,
	0x5EB6, 0x8F8E, 0x5EB7, 0x8D4E, 0x5EB8, 0x9766,
	0x5EC3, 0x9470, 0x5EC9, 0x97F5,
	0x5ECA, 0x984C, 0x5ED3, 0x8A66,
	0x5EDF, 0x955F, 0x5EE0, 0x8FB1, 0x5EE2, 0x9C45,
	0x5EE3, 0x9C41,
	0x5EF6, 0x8984, 0x5EF7, 0x92EC, 0x5EFA, 0x8C9A,
	0x5EFB, 0x89F4, 0x5EFC, 0x9455, 0x5EFF, 0x93F9,
	0x5F01, 0x95D9, 0x5F04, 0x984D,
	0x5F0A, 0x95BE, 0x5F0D, 0x98AF,
	0x5F0F, 0x8EAE, 0x5F10, 0x93F3, 0x5F13, 0x8B7C,
	0x5F14, 0x92A2, 0x5F15, 0x88F8, 0x5F17, 0x95A4,
	0x5F18, 0x8D4F, 0x5F1B, 0x926F, 0x5F1F, 0x92ED,
	0x5F25, 0x96ED, 0x5F26, 0x8CB7, 0x5F27, 0x8CCA,
	0x5F31, 0x8EE3,
	0x5F35, 0x92A3, 0x5F37, 0x8BAD, 0x5F3C, 0x954A,
	0x5F3E, 0x9265,
	0x5F4A, 0x8BAE,
	0x5F53, 0x9396, 0x5F57, 0x9C61, 0x5F59, 0x9C62,
	0x5F61, 0x9C63, 0x5F62, 0x8C60,
	0x5F66, 0x9546, 0x5F69, 0x8DCA, 0x5F6A, 0x9556,
	0x5F6B, 0x92A4, 0x5F6C, 0x956A, 0x5F70, 0x8FB2,
	0x5F71, 0x8965, 0x5F77, 0x9C66, 0x5F79, 0x96F0,
	0x5F7C, 0x94DE, 0x5F80, 0x899D, 0x5F81, 0x90AA,
	0x5F84, 0x8C61, 0x5F85, 0x91D2,
	0x5F8A, 0x9C6A, 0x5F8B, 0x97A5,
	0x5F8C, 0x8CE3, 0x5F90, 0x8F99, 0x5F92, 0x936B,
	0x5F93, 0x8F5D, 0x5F97, 0x93BE, 0x5F98, 0x9C70,
	0x5FA1, 0x8CE4,
	0x5FA9, 0x959C, 0x5FAA, 0x8F7A, 0x5FAE, 0x94F7,
	0x5FB3, 0x93BF, 0x5FB4, 0x92A5, 0x5FB9, 0x934F,
	0x5FBD, 0x8B4A, 0x5FC3, 0x9053, 0x5FC5, 0x954B,
	0x5FCC, 0x8AF5, 0x5FCD, 0x9445, 0x5FD7, 0x8E75,
	0x5FD8, 0x9659, 0x5FD9, 0x965A, 0x5FDC, 0x899E,
	0x5FE0, 0x9289, 0x5FEB, 0x89F5,
	0x5FF5, 0x944F,
	0x5FFD, 0x8D9A,
	0x6012, 0x937B,
	0x6016, 0x957C, 0x601C, 0x97E5,
	0x601D, 0x8E76, 0x6020, 0x91D3, 0x6025, 0x8B7D,
	0x6027, 0x90AB, 0x6028, 0x8985,
	0x602A, 0x89F6, 0x602F, 0x8BAF,
	0x604B, 0x97F6, 0x604D, 0x9C92,
	0x6050, 0x8BB0, 0x6052, 0x8D50, 0x6055, 0x8F9A,
	0x6062, 0x89F8, 0x6065, 0x9270,
	0x6068, 0x8DA6, 0x6069, 0x89B6, 0x606B, 0x9C98,
	0x606D, 0x8BB1, 0x606F, 0x91A7, 0x6070, 0x8A86,
	0x6075, 0x8C62,
	0x6089, 0x8EBB,
	0x608C, 0x92EE,
	0x6094, 0x89F7,
	0x609F, 0x8CE5, 0x60A0, 0x9749, 0x60A3, 0x8AB3,
	0x60A6, 0x8978, 0x60A9, 0x9459, 0x60AA, 0x88AB,
	0x60B2, 0x94DF,
	0x60B6, 0x96E3, 0x60BC, 0x9389,
	0x60C5, 0x8FEE, 0x60C7, 0x93D5, 0x60D1, 0x9866,
	0x60DA, 0x8D9B,
	0x60DC, 0x90C9, 0x60DF, 0x88D2,
	0x60E3, 0x9179, 0x60E8, 0x8E53,
	0x60F0, 0x91C4, 0x60F3, 0x917A,
	0x60F9, 0x8EE4,
	0x6101, 0x8F44,
	0x6108, 0x96FA, 0x6109, 0x96F9,
	0x610F, 0x88D3,
	0x611A, 0x8BF0, 0x611B, 0x88A4, 0x611F, 0x8AB4,
	0x6148, 0x8E9C,
	0x614B, 0x91D4, 0x614C, 0x8D51,
	0x614E, 0x9054, 0x6155, 0x95E7,
	0x6162, 0x969D, 0x6163, 0x8AB5, 0x6167, 0x8C64,
	0x6168, 0x8A53, 0x616E, 0x97B6,
	0x6170, 0x88D4,
	0x6176, 0x8C63, 0x617E, 0x977C,
	0x6182, 0x974A, 0x618E, 0x919E,
	0x6190, 0x97F7, 0x6191, 0x9CDF, 0x6194, 0x9CDC,
	0x61A4, 0x95AE,
	0x61A7, 0x93B2, 0x61A9, 0x8C65,
	0x61B2, 0x8C9B, 0x61B6, 0x89AF,
	0x61BE, 0x8AB6, 0x61C7, 0x8DA7,
	0x61D0, 0x89F9,
	0x61F2, 0x92A6,
	0x61F8, 0x8C9C,
	0x620A, 0x95E8,
	0x620E, 0x8F5E, 0x6210, 0x90AC, 0x6211, 0x89E4,
	0x6212, 0x89FA, 0x6216, 0x88BD,
	0x621A, 0x90CA,
	0x621F, 0x8C81, 0x6226, 0x90ED,
	0x622E, 0x9D43, 0x622F, 0x8B59, 0x6230, 0x9D44,
	0x6234, 0x91D5, 0x6238, 0x8CCB, 0x623B, 0x96DF,
	0x623F, 0x965B, 0x6240, 0x8F8A, 0x6247, 0x90EE,
	0x6249, 0x94E0, 0x624B, 0x8EE8, 0x624D, 0x8DCB,
	0x6253, 0x91C5, 0x6255, 0x95A5, 0x6258, 0x91EF,
	0x626E, 0x95AF, 0x6271, 0x88B5, 0x6276, 0x957D,
	0x6279, 0x94E1, 0x627F, 0x8FB3,
	0x6280, 0x8B5A, 0x6284, 0x8FB4,
	0x628A, 0x9463, 0x6291, 0x977D,
	0x6295, 0x938A,
	0x6297, 0x8D52, 0x6298, 0x90DC, 0x629C, 0x94B2,
	0x629E, 0x91F0, 0x62AB, 0x94E2,
	0x62B1, 0x95F8, 0x62B5, 0x92EF, 0x62B9, 0x9695,
	0x62BC, 0x899F, 0x62BD, 0x928A, 0x62C5, 0x9253,
	0x62C9, 0x9D66,
	0x62CD, 0x948F,
	0x62D0, 0x89FB, 0x62D2, 0x8B91, 0x62D3, 0x91F1,
	0x62D8, 0x8D53, 0x62D9, 0x90D9,
	0x62DB, 0x8FB5, 0x62DD, 0x9471, 0x62E0, 0x8B92,
	0x62E1, 0x8A67, 0x62EC, 0x8A87, 0x62ED, 0x9040,
	0x62F3, 0x8C9D,
	0x62F6, 0x8E41, 0x62F7, 0x8D89, 0x62FE, 0x8F45,
	0x6301, 0x8E9D, 0x6307, 0x8E77,
	0x6309, 0x88C2, 0x6311, 0x92A7, 0x6319, 0x8B93,
	0x631F, 0x8BB2, 0x6328, 0x88A5, 0x632B, 0x8DC1,
	0x632F, 0x9055, 0x633A, 0x92F0, 0x633D, 0x94D2,
	0x633F, 0x917D, 0x6349, 0x91A8, 0x634C, 0x8E4A,
	0x6355, 0x95DF, 0x6357, 0x92BB,
	0x635C, 0x917B, 0x6367, 0x95F9, 0x6368, 0x8ECC,
	0x636E, 0x9098, 0x6372, 0x8C9E,
	0x6377, 0x8FB7, 0x637A, 0x93E6, 0x637B, 0x9450,
	0x6383, 0x917C, 0x6388, 0x8EF6, 0x638C, 0x8FB6,
	0x6392, 0x9472,
	0x6398, 0x8C40, 0x639B, 0x8A7C, 0x63A0, 0x97A9,
	0x63A1, 0x8DCC, 0x63A2, 0x9254, 0x63A5, 0x90DA,
	0x63A7, 0x8D54, 0x63A8, 0x9084, 0x63A9, 0x8986, 0x63AA, 0x915B,
	0x63AC, 0x8B64, 0x63B2, 0x8C66, 0x63B4, 0x92CD,
	0x63BB, 0x917E,
	0x63C3, 0x91B5, 0x63C4, 0x9D89, 0x63C9, 0x9D86,
	0x63CF, 0x9560, 0x63D0, 0x92F1, 0x63D6, 0x974B,
	0x63DA, 0x9767, 0x63DB, 0x8AB7, 0x63E1, 0x88AC,
	0x63EE, 0x8AF6, 0x63F4, 0x8987,
	0x63F6, 0x9D88, 0x63FA, 0x9768, 0x640D, 0x91B9,
	0x6416, 0x9D8A,
	0x642C, 0x94C0,
	0x642D, 0x938B, 0x643A, 0x8C67,
	0x643E, 0x8DEF, 0x6442, 0x90DB, 0x6458, 0x9345,
	0x6469, 0x9680,
	0x6478, 0x96CC, 0x647A, 0x90A0, 0x6483, 0x8C82,
	0x6492, 0x8E54,
	0x649A, 0x9451, 0x649E, 0x93B3, 0x64A4, 0x9350,
	0x64A5, 0x9D9B, 0x64AB, 0x958F, 0x64AD, 0x9464,
	0x64AE, 0x8E42, 0x64B0, 0x90EF, 0x64B2, 0x966F, 0x64B9, 0x8A68,
	0x64C1, 0x9769,
	0x64CD, 0x9180,
	0x64E2, 0x9346,
	0x64E6, 0x8E43, 0x64EC, 0x8B5B,
	0x64FE, 0x8FEF,
	0x652A, 0x9D98,
	0x652F, 0x8E78,
	0x6539, 0x89FC,
	0x653B, 0x8D55, 0x653E, 0x95FA, 0x653F, 0x90AD, 0x6545, 0x8CCC,
	0x654F, 0x9571,
	0x6551, 0x8B7E, 0x6557, 0x9473,
	0x6559, 0x8BB3,
	0x6562, 0x8AB8, 0x6563, 0x8E55, 0x6566, 0x93D6, 0x656C, 0x8C68,
	0x6570, 0x9094, 0x6574, 0x90AE, 0x6575, 0x9347,
	0x6577, 0x957E,
	0x6587, 0x95B6, 0x6589, 0x90C4, 0x658C, 0x956B,
	0x658E, 0x8DD6, 0x6590, 0x94E3, 0x6591, 0x94C1, 0x6597, 0x936C,
	0x6599, 0x97BF, 0x659C, 0x8ECE,
	0x65A1, 0x88B4, 0x65A4, 0x8BD2, 0x65A5, 0x90CB, 0x65A7, 0x9580,
	0x65AC, 0x8E61, 0x65AD, 0x9266, 0x65AF, 0x8E7A,
	0x65B0, 0x9056, 0x65B9, 0x95FB, 0x65BC, 0x8997,
	0x65BD, 0x8E7B,
	0x65C5, 0x97B7, 0x65CB, 0x90F9,
	0x65CF, 0x91B0, 0x65D7, 0x8AF8,
	0x65E2, 0x8AF9,
	0x65E5, 0x93FA, 0x65E6, 0x9255, 0x65E7, 0x8B8C, 0x65E8, 0x8E7C,
	0x65E9, 0x9181, 0x65EC, 0x8F7B, 0x65ED, 0x88AE,
	0x65FA, 0x89A0, 0x6602, 0x8D56,
	0x6606, 0x8DA9, 0x6607, 0x8FB8,
	0x660C, 0x8FB9, 0x660E, 0x96BE, 0x660F, 0x8DA8,
	0x6613, 0x88D5, 0x6614, 0x90CC,
	0x661F, 0x90AF, 0x6620, 0x8966,
	0x6625, 0x8F74, 0x6627, 0x9686, 0x6628, 0x8DF0, 0x662D, 0x8FBA,
	0x662F, 0x90A5, 0x6634, 0x9DE3,
	0x663C, 0x928B,
	0x6642, 0x8E9E, 0x6643, 0x8D57,
	0x664B, 0x9057,
	0x6652, 0x8E4E,
	0x6666, 0x8A41,
	0x6669, 0x94D3, 0x666E, 0x9581, 0x666F, 0x8C69,
	0x6674, 0x90B0, 0x6676, 0x8FBB, 0x667A, 0x9271,
	0x6681, 0x8BC5, 0x6687, 0x89C9,
	0x6691, 0x8F8B,
	0x6696, 0x9267, 0x6697, 0x88C3,
	0x66A2, 0x92A8, 0x66A6, 0x97EF,
	0x66AB, 0x8E62, 0x66AE, 0x95E9, 0x66B4, 0x965C,
	0x66C7, 0x93DC,
	0x66D9, 0x8F8C,
	0x66DC, 0x976A, 0x66DD, 0x9498,
	0x66F2, 0x8BC8, 0x66F3, 0x8967,
	0x66F4, 0x8D58, 0x66F8, 0x8F91,
	0x66F9, 0x9182,
	0x66FD, 0x915D, 0x66FE, 0x915C, 0x66FF, 0x91D6, 0x6700, 0x8DC5,
	0x6703, 0x98F0, 0x6708, 0x8C8E, 0x6709, 0x974C, 0x670B, 0x95FC,
	0x670D, 0x959E, 0x6714, 0x8DF1,
	0x6715, 0x92BD, 0x6717, 0x984E, 0x671B, 0x965D,
	0x671D, 0x92A9, 0x671F, 0x8AFA,
	0x6728, 0x96D8, 0x672A, 0x96A2, 0x672B, 0x9696,
	0x672C, 0x967B, 0x672D, 0x8E44, 0x6731, 0x8EE9,
	0x6734, 0x9670,
	0x673A, 0x8AF7, 0x673D, 0x8B80,
	0x6746, 0x9E57, 0x6749, 0x9099, 0x674E, 0x979B, 0x674F, 0x88C7,
	0x6750, 0x8DDE, 0x6751, 0x91BA, 0x6753, 0x8EDB, 0x6756, 0x8FF1,
	0x675C, 0x936D, 0x675E, 0x9E58, 0x675F, 0x91A9,
	0x6761, 0x8FF0, 0x6762, 0x96DB,
	0x6765, 0x9788,
	0x676D, 0x8D59, 0x676F, 0x9474, 0x6771, 0x938C,
	0x6775, 0x8B6E, 0x6777, 0x9466,
	0x677E, 0x8FBC, 0x677F, 0x94C2,
	0x6787, 0x94F8,
	0x6790, 0x90CD, 0x6795, 0x968D, 0x6797, 0x97D1, 0x679A, 0x9687,
	0x679C, 0x89CA, 0x679D, 0x8E7D, 0x67A0, 0x9867,
	0x67A2, 0x9095, 0x67AF, 0x8CCD,
	0x67B6, 0x89CB,
	0x67C1, 0x91C6, 0x67C4, 0x95BF, 0x67CA, 0x9541,
	0x67CF, 0x9490, 0x67D0, 0x965E, 0x67D1, 0x8AB9,
	0x67D3, 0x90F5, 0x67D4, 0x8F5F, 0x67D8, 0x92D1, 0x67DA, 0x974D,
	0x67F1, 0x928C, 0x67F3, 0x96F6, 0x67F4, 0x8EC4,
	0x67F5, 0x8DF2, 0x67FB, 0x8DB8, 0x67FE, 0x968F, 0x67FF, 0x8A60,
	0x6802, 0x92CC, 0x6803, 0x93C8, 0x6804, 0x8968,
	0x6813, 0x90F0, 0x6816, 0x90B2, 0x6817, 0x8C49,
	0x6821, 0x8D5A, 0x6822, 0x8A9C, 0x682A, 0x8A94,
	0x6834, 0x90F1, 0x6838, 0x8A6A,
	0x6839, 0x8DAA, 0x683C, 0x8A69, 0x683D, 0x8DCD,
	0x6841, 0x8C85, 0x6842, 0x8C6A, 0x6843, 0x938D,
	0x6848, 0x88C4,
	0x6850, 0x8BCB, 0x6851, 0x8C4B, 0x6853, 0x8ABA,
	0x6854, 0x8B6A, 0x685C, 0x8DF7, 0x685D, 0x9691,
	0x685F, 0x8E56, 0x6867, 0x954F,
	0x6876, 0x89B1,
	0x6881, 0x97C0, 0x6885, 0x947E,
	0x6893, 0x88B2, 0x6897, 0x8D5B,
	0x68A2, 0x8FBD, 0x68A7, 0x8CE6, 0x68A8, 0x979C,
	0x68AF, 0x92F2, 0x68B0, 0x8A42, 0x68B1, 0x8DAB,
	0x68B5, 0x9E90, 0x68B6, 0x8A81,
	0x68BC, 0x938E, 0x68C4, 0x8AFC,
	0x68C9, 0x96C7, 0x68CB, 0x8AFB,
	0x68CD, 0x9E9E, 0x68D2, 0x965F,
	0x68DA, 0x9249,
	0x68DF, 0x938F,
	0x68EE, 0x9058, 0x68F2, 0x90B1,
	0x68FA, 0x8ABB, 0x6900, 0x986F,
	0x6905, 0x88D6, 0x690B, 0x96B8,
	0x690D, 0x9041, 0x690E, 0x92C5,
	0x6919, 0x909A, 0x691B, 0x8A91,
	0x691C, 0x8C9F,
	0x6934, 0x93CC,
	0x693F, 0x92D6, 0x694A, 0x976B, 0x6953, 0x9596,
	0x6955, 0x91C8, 0x695A, 0x915E,
	0x6960, 0x93ED,
	0x6962, 0x93E8,
	0x696D, 0x8BC6, 0x696F, 0x8F7C,
	0x6973, 0x9480, 0x6975, 0x8BC9,
	0x697C, 0x984F, 0x697D, 0x8A79,
	0x6982, 0x8A54, 0x698A, 0x8DE5,
	0x698E, 0x897C, 0x6994, 0x9850,
	0x699B, 0x9059,
	0x69AE, 0x9EC4,
	0x69C7, 0xEAA0,
	0x69CB, 0x8D5C, 0x69CC, 0x92C6, 0x69CD, 0x9184,
	0x69D8, 0x976C, 0x69D9, 0x968A,
	0x69FB, 0x92CE, 0x69FD, 0x9185,
	0x6A0B, 0x94F3,
	0x6A17, 0x9294, 0x6A19, 0x9557,
	0x6A1F, 0x8FBE, 0x6A21, 0x96CD,
	0x6A29, 0x8CA0, 0x6A2A, 0x89A1, 0x6A2B, 0x8A7E,
	0x6A35, 0x8FBF,
	0x6A39, 0x8EF7, 0x6A3A, 0x8A92, 0x6A3D, 0x924D,
	0x6A4B, 0x8BB4,
	0x6A58, 0x8B6B, 0x6A59, 0x9EF2, 0x6A5F, 0x8B40, 0x6A61, 0x93C9,
	0x6A7F, 0x8A80,
	0x6A80, 0x9268, 0x6A8E, 0x8CE7,
	0x6AAC, 0x9F47,
	0x6AB8, 0x9F45, 0x6ABB, 0x9F42,
	0x6AC2, 0x9F44,
	0x6AD3, 0x9845, 0x6ADB, 0x8BF9,
	0x6AE8, 0x94A5,
	0x6B04, 0x9793,
	0x6B05, 0x9F4F,
	0x6B1D, 0x8954, 0x6B20, 0x8C87, 0x6B21, 0x8E9F,
	0x6B23, 0x8BD3, 0x6B27, 0x89A2, 0x6B32, 0x977E,
	0x6B3A, 0x8B5C, 0x6B3D, 0x8BD4,
	0x6B3E, 0x8ABC,
	0x6B4C, 0x89CC, 0x6B4E, 0x9256, 0x6B53, 0x8ABD,
	0x6B62, 0x8E7E, 0x6B63, 0x90B3, 0x6B64, 0x8D9F,
	0x6B66, 0x9590, 0x6B69, 0x95E0, 0x6B6A, 0x9863, 0x6B6F, 0x8E95,
	0x6B73, 0x8DCE, 0x6B74, 0x97F0,
	0x6B7B, 0x8E80,
	0x6B86, 0x9677, 0x6B89, 0x8F7D, 0x6B8A, 0x8EEA,
	0x6B8B, 0x8E63, 0x6B96, 0x9042,
	0x6BB2, 0x9F72,
	0x6BB4, 0x89A3, 0x6BB5, 0x9269,
	0x6BBA, 0x8E45, 0x6BBB, 0x8A6B, 0x6BBF, 0x9361,
	0x6BC5, 0x8B42,
	0x6BCD, 0x95EA, 0x6BCE, 0x9688, 0x6BD2, 0x93C5,
	0x6BD4, 0x94E4, 0x6BD8, 0x94F9, 0x6BDB, 0x96D1,
	0x6BEC, 0x9F7B, 0x6BEF, 0x9F7E,
	0x6C0F, 0x8E81, 0x6C11, 0x96AF,
	0x6C17, 0x8B43,
	0x6C23, 0x9F86, 0x6C34, 0x9085, 0x6C37, 0x9558,
	0x6C38, 0x8969, 0x6C3E, 0x94C3, 0x6C40, 0x92F3,
	0x6C41, 0x8F60, 0x6C42, 0x8B81, 0x6C4E, 0x94C4, 0x6C50, 0x8EAC,
	0x6C57, 0x8ABE, 0x6C5A, 0x8998,
	0x6C5D, 0x93F0, 0x6C5F, 0x8D5D, 0x6C60, 0x9272,
	0x6C70, 0x91BF, 0x6C72, 0x8B82, 0x6C7A, 0x8C88,
	0x6C7D, 0x8B44,
	0x6C83, 0x9780, 0x6C88, 0x92BE, 0x6C8C, 0x93D7,
	0x6C93, 0x8C42,
	0x6C96, 0x89AB, 0x6C99, 0x8DB9,
	0x6CA1, 0x9676, 0x6CA2, 0x91F2, 0x6CAB, 0x9697,
	0x6CB3, 0x89CD, 0x6CB8, 0x95A6, 0x6CB9, 0x96FB,
	0x6CBB, 0x8EA1, 0x6CBC, 0x8FC0,
	0x6CBF, 0x8988, 0x6CC1, 0x8BB5,
	0x6CC9, 0x90F2, 0x6CCA, 0x9491, 0x6CCC, 0x94E5,
	0x6CD5, 0x9640,
	0x6CE1, 0x9641,
	0x6CE2, 0x9467, 0x6CE3, 0x8B83, 0x6CE5, 0x9344, 0x6CE8, 0x928D,
	0x6CF0, 0x91D7,
	0x6CF3, 0x896A, 0x6D0B, 0x976D,
	0x6D17, 0x90F4, 0x6D1B, 0x978C,
	0x6D1E, 0x93B4, 0x6D25, 0x92C3, 0x6D29, 0x896B,
	0x6D2A, 0x8D5E, 0x6D32, 0x8F46,
	0x6D3B, 0x8A88,
	0x6D3E, 0x9468, 0x6D41, 0x97AC, 0x6D44, 0x8FF2,
	0x6D45, 0x90F3, 0x6D5C, 0x956C,
	0x6D66, 0x8959, 0x6D69, 0x8D5F,
	0x6D6A, 0x9851, 0x6D6C, 0x8A5C, 0x6D6E, 0x9582,
	0x6D74, 0x9781, 0x6D77, 0x8A43, 0x6D78, 0x905A,
	0x6D88, 0x8FC1, 0x6D8C, 0x974F,
	0x6D99, 0x97DC, 0x6D9B, 0x9393, 0x6D9C, 0x93C0,
	0x6DAF, 0x8A55, 0x6DB2, 0x8974,
	0x6DBC, 0x97C1, 0x6DC0, 0x9784,
	0x6DCB, 0x97D2,
	0x6DD1, 0x8F69, 0x6DD8, 0x9391,
	0x6DE1, 0x9257,
	0x6DEB, 0x88FA,
	0x6DF1, 0x905B,
	0x6DF3, 0x8F7E, 0x6DF5, 0x95A3, 0x6DF7, 0x8DAC,
	0x6DFB, 0x9359,
	0x6E05, 0x90B4, 0x6E07, 0x8A89, 0x6E08, 0x8DCF, 0x6E09, 0x8FC2,
	0x6E0B, 0x8F61, 0x6E13, 0x8C6B,
	0x6E1A, 0x8F8D, 0x6E1B, 0x8CB8,
	0x6E20, 0x8B94, 0x6E21, 0x936E,
	0x6E25, 0x88AD, 0x6E26, 0x8951,
	0x6E29, 0x89B7, 0x6E2C, 0x91AA,
	0x6E2F, 0x8D60,
	0x6E4A, 0x96A9, 0x6E56, 0x8CCE,
	0x6E58, 0x8FC3, 0x6E5B, 0x9258,
	0x6E67, 0x974E, 0x6E6F, 0x9392,
	0x6E7E, 0x9870, 0x6E7F, 0x8EBC,
	0x6E80, 0x969E, 0x6E8C, 0x94AC,
	0x6E90, 0x8CB9, 0x6E96, 0x8F80, 0x6E9C, 0x97AD,
	0x6E9D, 0x8D61, 0x6EA2, 0x88EC,
	0x6EB6, 0x976E,
	0x6EBA, 0x934D,
	0x6EC5, 0x96C5,
	0x6ECB, 0x8EA0, 0x6ECC, 0x9FFC, 0x6ED1, 0x8A8A, 0x6ED3, 0x9FE6,
	0x6EDD, 0x91EA, 0x6EDE, 0x91D8,
	0x6EF2, 0x9FF8, 0x6EF4, 0x9348,
	0x6F01, 0x8B99, 0x6F02, 0x9559, 0x6F06, 0x8EBD, 0x6F09, 0x8D97,
	0x6F0F, 0x9852, 0x6F11, 0x9FF2, 0x6F14, 0x8989,
	0x6F15, 0x9186, 0x6F20, 0x9499, 0x6F22, 0x8ABF, 0x6F23, 0x97F8,
	0x6F2B, 0x969F, 0x6F2C, 0x92D0, 0x6F31, 0x9FF9,
	0x6F38, 0x9151,
	0x6F45, 0x8AC1, 0x6F54, 0x8C89,
	0x6F5C, 0x90F6, 0x6F5F, 0x8A83, 0x6F64, 0x8F81,
	0x6F6E, 0x92AA, 0x6F70, 0x92D7,
	0x6F84, 0x909F,
	0x6F97, 0x8AC0, 0x6FA4, 0xE056,
	0x6FB1, 0x9362,
	0x6FC0, 0x8C83, 0x6FC1, 0x91F7,
	0x6FC3, 0x945A,
	0x6FE0, 0x8D8A,
	0x6FE1, 0x9447, 0x6FEB, 0x9794,
	0x6FEF, 0x91F3,
	0x7015, 0x956D,
	0x701E, 0x93D2, 0x7026, 0x9295, 0x7027, 0x91EB,
	0x702C, 0x90A3,
	0x704C, 0x9FF3, 0x7058, 0x93E5,
	0x706B, 0x89CE, 0x706F, 0x9394, 0x7070, 0x8A44,
	0x7078, 0x8B84, 0x707C, 0x8EDC, 0x707D, 0x8DD0,
	0x7089, 0x9846, 0x708A, 0x9086, 0x708E, 0x898A, 0x7092, 0xE075,
	0x7099, 0xE074, 0x70AC, 0xE078, 0x70AD, 0x9259,
	0x70B8, 0xE079,
	0x70B9, 0x935F, 0x70BA, 0x88D7, 0x70C8, 0x97F3,
	0x70CF, 0x8947, 0x70D9, 0xE080, 0x70DD, 0xE07E,
	0x70F9, 0x9642,
	0x7109, 0xE081, 0x7114, 0x898B,
	0x7119, 0xE084, 0x711A, 0x95B0, 0x711C, 0xE083, 0x7121, 0x96B3,
	0x7126, 0x8FC5, 0x7136, 0x9152, 0x713C, 0x8FC4,
	0x7149, 0x97F9, 0x714C, 0xE08A, 0x714E, 0x90F7,
	0x7159, 0x898C,
	0x7164, 0x9481,
	0x7167, 0x8FC6, 0x7169, 0x94CF, 0x716E, 0x8ECF,
	0x717D, 0x90F8, 0x718A, 0x8C46,
	0x718F, 0xE08D, 0x7194, 0x976F,
	0x719F, 0x8F6E, 0x71A8, 0xE091, 0x71B1, 0x944D,
	0x71C3, 0x9452,
	0x71C8, 0x9395, 0x71C9, 0xE097, 0x71CE, 0xE099, 0x71D0, 0x97D3,
	0x71D2, 0xE096, 0x71D5, 0x898D, 0x71D7, 0xE093,
	0x71E5, 0x9187, 0x71E6, 0x8E57,
	0x71ED, 0x9043,
	0x71FB, 0xE08E,
	0x7206, 0x949A,
	0x722A, 0x92DC,
	0x722C, 0xE0A6, 0x722D, 0xE0A5, 0x7232, 0xE0A8,
	0x7235, 0x8EDD, 0x7236, 0x9583, 0x723A, 0x96EA,
	0x723D, 0x9175, 0x723E, 0x8EA2,
	0x7247, 0x95D0, 0x7248, 0x94C5,
	0x724C, 0x9476, 0x7252, 0x92AB,
	0x7259, 0x89E5, 0x725B, 0x8B8D, 0x725D, 0x96C4, 0x725F, 0x96B4,
	0x7261, 0x89B2, 0x7262, 0x9853, 0x7267, 0x9671, 0x7269, 0x95A8,
	0x7272, 0x90B5, 0x7279, 0x93C1, 0x727D, 0x8CA1,
	0x7280, 0x8DD2,
	0x72A0, 0x8B5D,
	0x72AC, 0x8CA2, 0x72AF, 0x94C6,
	0x72B6, 0x8FF3,
	0x72C2, 0x8BB6,
	0x72D0, 0x8CCF,
	0x72D7, 0x8BE7, 0x72D9, 0x915F, 0x72DB, 0x8D9D,
	0x72E1, 0xE0C2, 0x72E2, 0xE0C0, 0x72E9, 0x8EEB, 0x72EC, 0x93C6,
	0x72ED, 0x8BB7, 0x72F8, 0x924B, 0x72F9, 0xE0C3,
	0x72FC, 0x9854, 0x72FD, 0x9482,
	0x731B, 0x96D2,
	0x731F, 0x97C2, 0x7325, 0xE0CE,
	0x732A, 0x9296, 0x732B, 0x944C, 0x732E, 0x8CA3,
	0x7336, 0x9750, 0x7337, 0x9751, 0x733E, 0xE0CF,
	0x733F, 0x898E, 0x7344, 0x8D96, 0x7345, 0x8E82,
	0x7363, 0x8F62, 0x7368, 0xE0D5,
	0x7370, 0xE0D6, 0x7372, 0x8A6C,
	0x7384, 0x8CBA, 0x7387, 0x97A6, 0x7389, 0x8BCA, 0x738B, 0x89A4,
	0x7396, 0x8BE8, 0x73A9, 0x8ADF, 0x73B2, 0x97E6,
	0x73C0, 0xE0DF, 0x73C2, 0x89CF,
	0x73CA, 0x8E58, 0x73CD, 0x92BF,
	0x73E0, 0x8EEC, 0x73EA, 0x8C5D,
	0x73ED, 0x94C7,
	0x73FE, 0x8CBB, 0x7403, 0x8B85,
	0x7406, 0x979D, 0x7409, 0x97AE, 0x7422, 0x91F4,
	0x7433, 0x97D4, 0x7434, 0x8BD5,
	0x7435, 0x94FA, 0x7436, 0x9469,
	0x745A, 0x8CE8,
	0x745B, 0x896C, 0x745E, 0x9090,
	0x7460, 0x97DA,
	0x746A, 0xE0F3,
	0x7473, 0x8DBA, 0x7483, 0x979E,
	0x74B0, 0x8AC2, 0x74BD, 0x8EA3,
	0x74DC, 0x895A,
	0x74E2, 0x955A, 0x74E6, 0x8AA2,
	0x74F6, 0x9572,
	0x7511, 0x8D99, 0x7518, 0x8AC3,
	0x751A, 0x9072, 0x751C, 0x935B, 0x751F, 0x90B6,
	0x7523, 0x8E59, 0x7525, 0x8999, 0x7526, 0xE153, 0x7528, 0x9770,
	0x752B, 0x95E1, 0x7530, 0x9363,
	0x7531, 0x9752, 0x7532, 0x8D62, 0x7533, 0x905C, 0x7537, 0x926A,
	0x753A, 0x92AC, 0x753B, 0x89E6,
	0x7546, 0xE15B,
	0x754C, 0x8A45, 0x754F, 0x88D8,
	0x7551, 0x94A8, 0x7554, 0x94C8, 0x7559, 0x97AF,
	0x755C, 0x927B, 0x755D, 0x90A4, 0x7560, 0x94A9,
	0x7562, 0x954C, 0x7565, 0x97AA, 0x7566, 0x8C6C,
	0x756A, 0x94D4,
	0x7570, 0x88D9, 0x7573, 0x8FF4,
	0x7577, 0x93EB,
	0x757F, 0x8B45,
	0x758B, 0x9544, 0x758E, 0x9161,
	0x758F, 0x9160, 0x7591, 0x8B5E,
	0x75AB, 0x8975,
	0x75B2, 0x94E6, 0x75B5, 0xE172,
	0x75B9, 0x905D, 0x75BD, 0xE173,
	0x75BE, 0x8EBE, 0x75C5, 0x9561,
	0x75C7, 0x8FC7, 0x75D2, 0xE179,
	0x75D4, 0x8EA4, 0x75D5, 0x8DAD, 0x75D8, 0x9397,
	0x75DB, 0x92C9, 0x75E2, 0x979F,
	0x75E9, 0x9189,
	0x75F4, 0x9273,
	0x7642, 0x97C3,
	0x764C, 0x8AE0, 0x7652, 0x96FC,
	0x7656, 0x95C8,
	0x767A, 0x94AD, 0x767B, 0x936F,
	0x767D, 0x9492, 0x767E, 0x9553,
	0x7684, 0x9349, 0x7686, 0x8A46,
	0x7687, 0x8D63,
	0x7690, 0x8E48,
	0x76AE, 0x94E7,
	0x76BF, 0x8E4D, 0x76C3, 0x9475, 0x76C6, 0x967E,
	0x76C8, 0x896D, 0x76CA, 0x8976,
	0x76D7, 0x9390, 0x76DB, 0x90B7,
	0x76DF, 0x96BF, 0x76E3, 0x8AC4,
	0x76E4, 0x94D5,
	0x76EE, 0x96DA, 0x76F2, 0x96D3, 0x76F4, 0x92BC, 0x76F8, 0x918A,
	0x76FE, 0x8F82, 0x7701, 0x8FC8,
	0x7709, 0x94FB, 0x770B, 0x8AC5,
	0x770C, 0x8CA7, 0x771F, 0x905E,
	0x7720, 0x96B0,
	0x7737, 0xE1C5, 0x773A, 0x92AD,
	0x773C, 0x8AE1, 0x7740, 0x9285,
	0x7761, 0x9087, 0x7763, 0x93C2,
	0x7766, 0x9672, 0x7768, 0xE1C9, 0x776B, 0xE1CA,
	0x777E, 0xE1CE,
	0x7791, 0xE1D2,
	0x77A5, 0x95CB, 0x77AC, 0x8F75, 0x77AD, 0x97C4,
	0x77B3, 0x93B5,
	0x77BC, 0xE1D9,
	0x77DB, 0x96B5,
	0x77E2, 0x96EE, 0x77E5, 0x926D,
	0x77E7, 0x948A, 0x77E9, 0x8BE9, 0x77ED, 0x925A, 0x77EE, 0xE1E2,
	0x77EF, 0x8BB8, 0x77F3, 0x90CE, 0x7802, 0x8DBB,
	0x7812, 0xE1E5, 0x7814, 0x8CA4, 0x7815, 0x8DD3,
	0x7825, 0x9375, 0x7826, 0x8DD4,
	0x7827, 0x8B6D, 0x7832, 0x9643, 0x7834, 0x946A, 0x783A, 0x9376,
	0x783F, 0x8D7B, 0x7845, 0xE1E9, 0x785D, 0x8FC9,
	0x786B, 0x97B0, 0x786C, 0x8D64, 0x786F, 0x8CA5,
	0x7872, 0x94A1, 0x787C, 0xE1ED,
	0x7881, 0x8CE9, 0x7887, 0x92F4,
	0x788D, 0x8A56, 0x7891, 0x94E8, 0x7893, 0x894F,
	0x7895, 0x8DEA, 0x7897, 0x9871,
	0x78A7, 0x95C9, 0x78A9, 0x90D7, 0x78AF, 0xE1F3,
	0x78BA, 0x8A6D,
	0x78C1, 0x8EA5,
	0x78D0, 0x94D6,
	0x78E8, 0x9681,
	0x78EF, 0x88E9, 0x7901, 0x8FCA,
	0x790E, 0x9162,
	0x792B, 0xE249,
	0x793A, 0x8EA6, 0x793C, 0x97E7,
	0x793E, 0x8ED0, 0x7940, 0xE24A, 0x7941, 0x8C56, 0x7947, 0x8B5F,
	0x7948, 0x8B46, 0x7949, 0x8E83, 0x7950, 0x9753, 0x7953, 0xE250,
	0x7956, 0x9163, 0x7957, 0xE24C,
	0x795D, 0x8F6A, 0x795E, 0x905F, 0x795F, 0xE24D, 0x7960, 0xE24B,
	0x7962, 0x9449, 0x7965, 0x8FCB, 0x7968, 0x955B, 0x796D, 0x8DD5,
	0x7977, 0x9398,
	0x7981, 0x8BD6, 0x7984, 0x985C, 0x7985, 0x9154, 0x798A, 0xE253,
	0x798D, 0x89D0, 0x798E, 0x92F5, 0x798F, 0x959F,
	0x79A6, 0x8B9A,
	0x79B0, 0x9448,
	0x79BD, 0x8BD7, 0x79BE, 0x89D1,
	0x79BF, 0x93C3, 0x79C0, 0x8F47, 0x79C1, 0x8E84,
	0x79CB, 0x8F48, 0x79D1, 0x89C8, 0x79D2, 0x9562,
	0x79D8, 0x94E9, 0x79DF, 0x9164,
	0x79E4, 0x9489, 0x79E6, 0x9060, 0x79E9, 0x9281,
	0x79F0, 0x8FCC, 0x79FB, 0x88DA, 0x7A00, 0x8B48,
	0x7A0B, 0x92F6, 0x7A0E, 0x90C5,
	0x7A14, 0x96AB, 0x7A17, 0x9542,
	0x7A1A, 0x9274, 0x7A1C, 0x97C5, 0x7A1F, 0xE267,
	0x7A2E, 0x8EED, 0x7A32, 0x88EE,
	0x7A3C, 0x89D2, 0x7A3D, 0x8C6D,
	0x7A3F, 0x8D65, 0x7A40, 0x8D92, 0x7A42, 0x95E4,
	0x7A46, 0x9673, 0x7A4D, 0x90CF, 0x7A4E, 0x896E,
	0x7A4F, 0x89B8, 0x7A50, 0x88AA, 0x7A57, 0xE26E,
	0x7A63, 0x8FF5, 0x7A6B, 0x8A6E,
	0x7A74, 0x8C8A, 0x7A76, 0x8B86,
	0x7A7A, 0x8BF3, 0x7A7F, 0x90FA, 0x7A81, 0x93CB,
	0x7A83, 0x90DE, 0x7A84, 0x8DF3, 0x7A92, 0x9282,
	0x7A93, 0x918B,
	0x7A9F, 0x8C41, 0x7AAA, 0x8C45,
	0x7AAE, 0x8B87, 0x7AAF, 0x9771,
	0x7ABA, 0x894D, 0x7AC3, 0x8A96,
	0x7ACB, 0x97A7,
	0x7ADC, 0x97B3,
	0x7AE0, 0x8FCD, 0x7AE3, 0x8F76,
	0x7AE5, 0x93B6, 0x7AEA, 0x9247,
	0x7AEF, 0x925B,
	0x7AF6, 0x8BA3, 0x7AF9, 0x927C, 0x7AFA, 0x8EB1,
	0x7AFF, 0x8AC6,
	0x7B08, 0x8B88,
	0x7B11, 0x8FCE, 0x7B1B, 0x934A,
	0x7B20, 0x8A7D, 0x7B25, 0x9079, 0x7B26, 0x9584,
	0x7B2C, 0x91E6,
	0x7B39, 0x8DF9, 0x7B46, 0x954D,
	0x7B48, 0x94A4, 0x7B49, 0x9399, 0x7B4B, 0x8BD8,
	0x7B4D, 0xE2A1, 0x7B4F, 0x94B3, 0x7B50, 0xE29E, 0x7B51, 0x927D,
	0x7B52, 0x939B, 0x7B54, 0x939A, 0x7B56, 0x8DF4,
	0x7B86, 0x95CD, 0x7B87, 0x89D3, 0x7B8B, 0xE2B3,
	0x7B92, 0xE2B4, 0x7B94, 0x9493,
	0x7B95, 0x96A5, 0x7B97, 0x8E5A,
	0x7BA1, 0x8AC7, 0x7BAA, 0x925C, 0x7BAD, 0x90FB,
	0x7BB1, 0x94A0, 0x7BB8, 0x94A2, 0x7BC0, 0x90DF,
	0x7BC4, 0x94CD, 0x7BC7, 0x95D1,
	0x7BC9, 0x927A,
	0x7BE0, 0x8EC2, 0x7BE4, 0x93C4,
	0x7BED, 0x9855,
	0x7C21, 0x8AC8,
	0x7C38, 0x94F4, 0x7C3E, 0x97FA,
	0x7C3F, 0x95EB,
	0x7C4D, 0x90D0,
	0x7C73, 0x95C4,
	0x7C7E, 0x96E0, 0x7C81, 0x8BCC, 0x7C82, 0x8C48,
	0x7C89, 0x95B2, 0x7C8B, 0x9088, 0x7C8D, 0x96AE,
	0x7C92, 0x97B1, 0x7C95, 0x9494, 0x7C97, 0x9165,
	0x7C98, 0x9453, 0x7C9B, 0x8F6C, 0x7C9F, 0x88BE,
	0x7CA5, 0x8A9F, 0x7CA7, 0x8FCF,
	0x7CBD, 0xE2EE, 0x7CBE, 0x90B8, 0x7CC0, 0xE2EF,
	0x7CCA, 0x8CD0, 0x7CCE, 0x9157,
	0x7CD6, 0x939C, 0x7CDE, 0x95B3,
	0x7CDF, 0x918C, 0x7CE0, 0x8D66, 0x7CE7, 0x97C6,
	0x7CF8, 0x8E85, 0x7CFB, 0x8C6E, 0x7CFE, 0x8B8A,
	0x7D00, 0x8B49, 0x7D04, 0x96F1, 0x7D05, 0x8D67,
	0x7D0B, 0x96E4, 0x7D0D, 0x945B,
	0x7D10, 0x9552, 0x7D14, 0x8F83, 0x7D17, 0x8ED1,
	0x7D18, 0x8D68, 0x7D19, 0x8E86, 0x7D1A, 0x8B89, 0x7D1B, 0x95B4,
	0x7D20, 0x9166, 0x7D21, 0x9661, 0x7D22, 0x8DF5,
	0x7D2B, 0x8E87, 0x7D2C, 0x92DB, 0x7D2F, 0x97DD,
	0x7D30, 0x8DD7, 0x7D33, 0x9061,
	0x7D39, 0x8FD0, 0x7D3A, 0x8DAE, 0x7D42, 0x8F49,
	0x7D43, 0x8CBC, 0x7D44, 0x9167, 0x7D46, 0xE34A,
	0x7D4C, 0x8C6F,
	0x7D50, 0x8C8B,
	0x7D5E, 0x8D69, 0x7D61, 0x978D, 0x7D62, 0x88BA,
	0x7D66, 0x8B8B, 0x7D68, 0xE34F,
	0x7D71, 0x939D, 0x7D75, 0x8A47,
	0x7D76, 0x90E2, 0x7D79, 0x8CA6,
	0x7D99, 0x8C70, 0x7D9A, 0x91B1,
	0x7D9C, 0x918E,
	0x7DAC, 0x8EF8,
	0x7DAD, 0x88DB,
	0x7DB1, 0x8D6A, 0x7DB2, 0x96D4, 0x7DB4, 0x92D4,
	0x7DBB, 0x925D,
	0x7DBE, 0x88BB, 0x7DBF, 0x96C8,
	0x7DCA, 0x8BD9, 0x7DCB, 0x94EA, 0x7DCF, 0x918D, 0x7DD1, 0x97CE,
	0x7DD2, 0x8F8F,
	0x7DDA, 0x90FC,
	0x7DE0, 0x92F7, 0x7DE8, 0x95D2,
	0x7DE9, 0x8AC9, 0x7DEC, 0x96C9, 0x7DEF, 0x88DC,
	0x7DF4, 0x97FB, 0x7DFB, 0xE36B, 0x7E01, 0x898F, 0x7E04, 0x93EA,
	0x7E0A, 0xE36F,
	0x7E1B, 0x949B, 0x7E1E, 0x8EC8,
	0x7E23, 0xE370, 0x7E26, 0x8F63,
	0x7E2B, 0x9644, 0x7E2E, 0x8F6B,
	0x7E3E, 0x90D1, 0x7E41, 0x94C9,
	0x7E4A, 0x9140, 0x7E4B, 0x8C71,
	0x7E4D, 0x8F4A, 0x7E54, 0x9044, 0x7E55, 0x9155,
	0x7E6D, 0x969A, 0x7E70, 0x8C4A,
	0x7E82, 0x8E5B,
	0x7E8F, 0x935A,
	0x7F36, 0x8ACA,
	0x7F6A, 0x8DDF, 0x7F6B, 0x8C72, 0x7F6E, 0x9275,
	0x7F70, 0x94B1, 0x7F72, 0x8F90, 0x7F75, 0x946C, 0x7F77, 0x94EB,
	0x7F85, 0x9785,
	0x7F8A, 0x9772, 0x7F8E, 0x94FC,
	0x7FA4, 0x8C51, 0x7FA8, 0x9141, 0x7FA9, 0x8B60,
	0x7FBD, 0x8948, 0x7FC1, 0x89A5,
	0x7FC5, 0xE3C0, 0x7FC6, 0xE3C1, 0x7FCC, 0x9782,
	0x7FD2, 0x8F4B, 0x7FD4, 0xE3C4, 0x7FE0, 0x9089,
	0x7FE6, 0xE3C6, 0x7FEB, 0x8AE3,
	0x7FF0, 0x8ACB, 0x7FFB, 0x967C,
	0x7FFC, 0x9783, 0x8000, 0x9773, 0x8001, 0x9856, 0x8003, 0x8D6C,
	0x8005, 0x8ED2,
	0x800C, 0x8EA7, 0x8010, 0x91CF, 0x8012, 0xE3CE, 0x8015, 0x8D6B,
	0x8017, 0x96D5,
	0x8033, 0x8EA8, 0x8036, 0x96EB,
	0x803D, 0x925E,
	0x804A, 0xE3D6, 0x8056, 0x90B9,
	0x805A, 0xE3DA, 0x805E, 0x95B7, 0x8061, 0x918F,
	0x806F, 0x97FC,
	0x8073, 0xE3DE, 0x8074, 0x92AE, 0x8076, 0xE3E1,
	0x8077, 0x9045, 0x807E, 0x9857,
	0x8087, 0x94A3, 0x8089, 0x93F7, 0x808B, 0x985D, 0x808C, 0x94A7,
	0x8096, 0x8FD1, 0x8098, 0x9549,
	0x809B, 0xE3E8, 0x809D, 0x8ACC, 0x80A1, 0x8CD2, 0x80A2, 0x8E88,
	0x80A5, 0x94EC, 0x80A9, 0x8CA8, 0x80AA, 0x9662,
	0x80AF, 0x8D6D, 0x80B1, 0x8D6E, 0x80B2, 0x88E7,
	0x80B4, 0x8DE6, 0x80BA, 0x9478, 0x80C3, 0x88DD,
	0x80C6, 0x925F, 0x80CC, 0x9477, 0x80CE, 0x91D9,
	0x80DA, 0xE3F3,
	0x80DE, 0x9645, 0x80E1, 0x8CD3, 0x80E4, 0x88FB,
	0x80F1, 0xE3F7, 0x80F4, 0x93B7, 0x80F8, 0x8BB9,
	0x80FD, 0x945C, 0x8102, 0x8E89, 0x8105, 0x8BBA,
	0x8106, 0x90C6, 0x8107, 0x9865, 0x8108, 0x96AC,
	0x810A, 0x90D2, 0x811A, 0x8B72,
	0x8131, 0x9245, 0x8133, 0x945D,
	0x8139, 0x92AF, 0x814B, 0xE3FC,
	0x814E, 0x9074, 0x8150, 0x9585,
	0x8154, 0x8D6F, 0x8155, 0x9872, 0x815F, 0xE454,
	0x816B, 0x8EEE, 0x8170, 0x8D98,
	0x8178, 0x92B0, 0x8179, 0x95A0,
	0x817A, 0x9142, 0x817F, 0x91DA,
	0x818F, 0x8D70,
	0x819A, 0x9586, 0x819C, 0x968C,
	0x819D, 0x9547, 0x81A0, 0xE450,
	0x81A8, 0x9663, 0x81B3, 0x9156,
	0x81B5, 0xE458,
	0x81BF, 0x945E,
	0x81C6, 0x89B0,
	0x81D3, 0x919F,
	0x81E3, 0x9062,
	0x81E5, 0x89E7, 0x81E8, 0x97D5, 0x81EA, 0x8EA9,
	0x81ED, 0x8F4C, 0x81F3, 0x8E8A, 0x81F4, 0x9276,
	0x81FC, 0x8950,
	0x8208, 0x8BBB,
	0x820C, 0x90E3,
	0x820E, 0x8EC9, 0x8210, 0xE472,
	0x8217, 0x95DC, 0x8218, 0x8ADA, 0x821B, 0x9143, 0x821C, 0x8F77,
	0x821E, 0x9591, 0x821F, 0x8F4D, 0x822A, 0x8D71,
	0x822C, 0x94CA,
	0x8235, 0x91C7, 0x8236, 0x9495, 0x8237, 0x8CBD,
	0x8239, 0x9144, 0x8247, 0x92F8,
	0x825A, 0xE47C,
	0x8264, 0xE47E, 0x8266, 0x8ACD,
	0x826E, 0x8DAF, 0x826F, 0x97C7,
	0x8272, 0x9046, 0x8276, 0x8990,
	0x828B, 0x88F0,
	0x8299, 0x9587, 0x829D, 0x8EC5,
	0x82A5, 0x8A48, 0x82A6, 0x88B0,
	0x82AD, 0x946D, 0x82AF, 0x9063, 0x82B1, 0x89D4, 0x82B3, 0x9646,
	0x82B8, 0x8C7C, 0x82B9, 0x8BDA, 0x82BD, 0x89E8,
	0x82C5, 0x8AA1, 0x82D1, 0x8991, 0x82D3, 0x97E8,
	0x82D4, 0x91DB, 0x82D7, 0x9563, 0x82DB, 0x89D5,
	0x82E5, 0x8EE1, 0x82E6, 0x8BEA, 0x82E7, 0x9297,
	0x82EB, 0x93CF, 0x82F1, 0x8970,
	0x82FA, 0xE495,
	0x8302, 0x96CE, 0x8304, 0x89D6, 0x8305, 0x8A9D,
	0x830E, 0x8C73,
	0x831C, 0x88A9,
	0x8328, 0x88EF, 0x832B, 0xE4A9,
	0x8334, 0xE4A0, 0x8336, 0x9283,
	0x8338, 0x91F9, 0x8339, 0xE4A5, 0x8340, 0xE4A4,
	0x8349, 0x9190, 0x834A, 0x8C74, 0x834F, 0x8960,
	0x8352, 0x8D72, 0x8358, 0x9191,
	0x8377, 0x89D7, 0x837B, 0x89AC,
	0x839E, 0x8ACE,
	0x83A2, 0xE4B0, 0x83AB, 0x949C,
	0x83B1, 0x9789,
	0x83C5, 0x909B, 0x83CA, 0x8B65, 0x83CC, 0x8BDB,
	0x83D3, 0x89D9, 0x83D6, 0x8FD2,
	0x83DC, 0x8DD8, 0x83DF, 0x9370, 0x83E9, 0x95EC,
	0x83EF, 0x89D8, 0x83F0, 0x8CD4, 0x83F1, 0x9548,
	0x8404, 0x93B8,
	0x840C, 0x9647,
	0x840E, 0x88DE,
	0x8429, 0x948B, 0x8431, 0x8A9E,
	0x843D, 0x978E,
	0x8449, 0x9774, 0x844E, 0x97A8,
	0x8457, 0x9298, 0x845B, 0x8A8B, 0x8461, 0x9592,
	0x8463, 0x939F, 0x8466, 0x88AF,
	0x846C, 0x9192,
	0x8471, 0x944B, 0x8475, 0x88A8,
	0x847A, 0x9598, 0x848B, 0x8FD3,
	0x8490, 0x8F4E, 0x8494, 0x8EAA, 0x8499, 0x96D6, 0x849C, 0x9566,
	0x849F, 0xE4E5, 0x84B2, 0x8A97,
	0x84B8, 0x8FF6, 0x84BB, 0xE4E8,
	0x84BC, 0x9193, 0x84C4, 0x927E,
	0x84C9, 0x9775, 0x84CB, 0x8A57,
	0x84D1, 0x96AA,
	0x84EC, 0x9648,
	0x84EE, 0x9840,
	0x8500, 0x8EC1, 0x8511, 0x95CC, 0x8513, 0x96A0,
	0x851A, 0x8955, 0x8526, 0x92D3,
	0x852D, 0x88FC, 0x8535, 0x91A0, 0x853D, 0x95C1,
	0x8543, 0x94D7,
	0x8549, 0x8FD4, 0x854A, 0x8EC7, 0x854E, 0x8BBC,
	0x8557, 0x9599,
	0x8568, 0x986E,
	0x8569, 0x93A0, 0x856A, 0x9593,
	0x857E, 0xE551, 0x8584, 0x9496,
	0x8597, 0x8992, 0x8599, 0x93E3,
	0x85A6, 0x9145,
	0x85A9, 0x8E46, 0x85AA, 0x9064, 0x85AB, 0x8C4F,
	0x85AC, 0x96F2, 0x85AE, 0x96F7, 0x85AF, 0x8F92,
	0x85C1, 0x986D,
	0x85CD, 0x9795,
	0x85E4, 0x93A1,
	0x85E9, 0x94CB, 0x85F7, 0x8F93,
	0x85FB, 0x9194,
	0x8607, 0x9168,
	0x862D, 0x9796,
	0x864E, 0x8CD5, 0x8650, 0x8B73,
	0x865A, 0x8B95, 0x865C, 0x97B8,
	0x865E, 0x8BF1, 0x866B, 0x928E,
	0x8679, 0x93F8, 0x867B, 0x88B8, 0x868A, 0x89E1,
	0x8695, 0x8E5C,
	0x86A4, 0x9461,
	0x86C7, 0x8ED6,
	0x86CB, 0x9260, 0x86CD, 0x8C75, 0x86CE, 0x8A61,
	0x86D9, 0x8A5E, 0x86DB, 0xE581,
	0x86E4, 0x94B8, 0x86ED, 0x9567,
	0x86EE, 0x94D8, 0x86F8, 0x91FB, 0x86F9, 0xE58C,
	0x86FE, 0x89E9, 0x8702, 0x9649,
	0x8718, 0x9277, 0x871C, 0x96A8,
	0x8749, 0x90E4, 0x874B, 0x9858,
	0x8755, 0x9049,
	0x8766, 0x89DA,
	0x8776, 0x92B1, 0x877F, 0x9488,
	0x8782, 0xE5A5, 0x878D, 0x975A, 0x87A2, 0xE5A3,
	0x87BA, 0x9786,
	0x87F2, 0xE5B3,
	0x87F9, 0x8A49, 0x87FB, 0x8B61,
	0x8805, 0xE5A2,
	0x8822, 0xE5BF,
	0x8840, 0x8C8C,
	0x8846, 0x8F4F, 0x884C, 0x8D73,
	0x8853, 0x8F70, 0x8857, 0x8A58, 0x885B, 0x8971,
	0x885D, 0x8FD5, 0x8861, 0x8D74,
	0x8863, 0x88DF, 0x8868, 0x955C, 0x8870, 0x908A,
	0x8877, 0x928F,
	0x887F, 0x8BDC,
	0x8888, 0x8C55, 0x888B, 0x91DC,
	0x8896, 0x91B3,
	0x88A2, 0xE5D9, 0x88AB, 0x94ED,
	0x88B4, 0x8CD1,
	0x88B7, 0x88BF, 0x88C1, 0x8DD9, 0x88C2, 0x97F4,
	0x88C5, 0x9195, 0x88CF, 0x97A0,
	0x88D4, 0xE5E1, 0x88D5, 0x9754,
	0x88DC, 0x95E2, 0x88DF, 0x8DBE, 0x88E1, 0x97A1,
	0x88F3, 0x8FD6,
	0x88F8, 0x9787,
	0x88FD, 0x90BB, 0x88FE, 0x909E,
	0x8907, 0x95A1, 0x8910, 0x8A8C,
	0x8912, 0x964A, 0x891D, 0xE5FA,
	0x8956, 0x89A6, 0x895E, 0xE5FC, 0x895F, 0x8BDD,
	0x8966, 0xE640,
	0x8972, 0x8F50, 0x8977, 0xE646,
	0x897F, 0x90BC, 0x8981, 0x9776,
	0x8986, 0x95A2, 0x8987, 0x9465,
	0x898B, 0x8CA9, 0x898F, 0x8B4B, 0x8996, 0x8E8B,
	0x8997, 0x9460, 0x899A, 0x8A6F,
	0x89A7, 0x9797, 0x89AA, 0x9065,
	0x89B3, 0x8ACF,
	0x89D2, 0x8A70,
	0x89E3, 0x89F0, 0x89E6, 0x9047,
	0x8A00, 0x8CBE, 0x8A02, 0x92F9,
	0x8A08, 0x8C76, 0x8A0A, 0x9075, 0x8A0E, 0x93A2,
	0x8A13, 0x8C50,
	0x8A17, 0x91F5, 0x8A18, 0x8B4C, 0x8A1B, 0xE661, 0x8A1D, 0xE662,
	0x8A1F, 0x8FD7, 0x8A23, 0x8C8D, 0x8A2A, 0x964B,
	0x8A2D, 0x90DD, 0x8A31, 0x8B96, 0x8A33, 0x96F3, 0x8A34, 0x9169,
	0x8A36, 0xE664, 0x8A3A, 0x9066, 0x8A3B, 0x9290,
	0x8A3C, 0x8FD8,
	0x8A50, 0x8DBC, 0x8A51, 0x91C0, 0x8A54, 0x8FD9,
	0x8A55, 0x955D, 0x8A5E, 0x8E8C, 0x8A60, 0x8972,
	0x8A63, 0x8C77, 0x8A66, 0x8E8E, 0x8A69, 0x8E8D,
	0x8A6B, 0x986C, 0x8A6E, 0x9146,
	0x8A70, 0x8B6C, 0x8A71, 0x9862, 0x8A72, 0x8A59, 0x8A73, 0x8FDA,
	0x8A87, 0x8CD6, 0x8A89, 0x975F, 0x8A8C, 0x8E8F,
	0x8A8D, 0x9446, 0x8A93, 0x90BE, 0x8A95, 0x9261,
	0x8A98, 0x9755, 0x8A9E, 0x8CEA, 0x8AA0, 0x90BD,
	0x8AA4, 0x8CEB,
	0x8AAC, 0x90E0,
	0x8AAD, 0x93C7, 0x8AB0, 0x924E, 0x8AB2, 0x89DB, 0x8AB9, 0x94EE,
	0x8ABC, 0x8B62, 0x8ABF, 0x92B2,
	0x8AC7, 0x926B, 0x8ACB, 0x90BF, 0x8ACC, 0x8AD0,
	0x8ACD, 0xE679, 0x8ACF, 0x907A, 0x8AD2, 0x97C8, 0x8AD6, 0x985F,
	0x8ADC, 0x92B3,
	0x8AE6, 0x92FA, 0x8AE7, 0xE67E, 0x8AEB, 0xE67C,
	0x8AED, 0x9740, 0x8AEE, 0x8E90,
	0x8AF8, 0x8F94, 0x8AFA, 0x8CBF,
	0x8AFE, 0x91F8, 0x8B00, 0x9664, 0x8B01, 0x8979, 0x8B02, 0x88E0,
	0x8B04, 0x93A3, 0x8B0E, 0x93E4,
	0x8B19, 0x8CAA, 0x8B1B, 0x8D75, 0x8B1D, 0x8ED3,
	0x8B21, 0x9777,
	0x8B2C, 0x9554, 0x8B33, 0xE690, 0x8B39, 0x8BDE,
	0x8B49, 0xE69A,
	0x8B58, 0x8EAF, 0x8B5C, 0x9588,
	0x8B66, 0x8C78,
	0x8B70, 0x8B63, 0x8B72, 0x8FF7,
	0x8B77, 0x8CEC,
	0x8B83, 0x8E5D,
	0x8B90, 0x8F51,
	0x8C37, 0x924A,
	0x8C46, 0x93A4,
	0x8C4A, 0x964C,
	0x8C5A, 0x93D8, 0x8C61, 0x8FDB,
	0x8C6A, 0x8D8B,
	0x8C79, 0x955E,
	0x8C8C, 0x9665,
	0x8C9D, 0x8A4C, 0x8C9E, 0x92E5, 0x8CA0, 0x9589,
	0x8CA1, 0x8DE0, 0x8CA2, 0x8D76, 0x8CA7, 0x956E, 0x8CA8, 0x89DD,
	0x8CA9, 0x94CC, 0x8CAB, 0x8AD1, 0x8CAC, 0x90D3,
	0x8CAF, 0x9299, 0x8CB0, 0x96E1,
	0x8CB4, 0x8B4D, 0x8CB6, 0xE6C8,
	0x8CB7, 0x9483, 0x8CB8, 0x91DD, 0x8CBB, 0x94EF, 0x8CBC, 0x935C,
	0x8CBF, 0x9666, 0x8CC0, 0x89EA,
	0x8CC2, 0x9847, 0x8CC3, 0x92C0, 0x8CC4, 0x9864, 0x8CC7, 0x8E91,
	0x8CCA, 0x91AF, 0x8CCE, 0x9147,
	0x8CD1, 0x93F6, 0x8CD3, 0x956F, 0x8CDB, 0x8E5E,
	0x8CDC, 0x8E92, 0x8CDE, 0x8FDC, 0x8CE0, 0x9485, 0x8CE2, 0x8CAB,
	0x8CE6, 0x958A, 0x8CEA, 0x8EBF,
	0x8CED, 0x9371,
	0x8CFC, 0x8D77, 0x8D04, 0xE6D1,
	0x8D05, 0xE6D2, 0x8D08, 0x91A1,
	0x8D0B, 0x8AE4,
	0x8D14, 0xE6DB,
	0x8D64, 0x90D4, 0x8D66, 0x8ECD, 0x8D6B, 0x8A71,
	0x8D70, 0x9196,
	0x8D74, 0x958B, 0x8D77, 0x8B4E,
	0x8D85, 0x92B4, 0x8D8A, 0x897A, 0x8DA3, 0x8EEF,
	0x8DA8, 0x9096, 0x8DB3, 0x91AB, 0x8DBE, 0xE6E4,
	0x8DCB, 0xE6EB,
	0x8DDD, 0x8B97,
	0x8DE1, 0x90D5, 0x8DE8, 0x8CD7,
	0x8DEA, 0xE6EC, 0x8DEF, 0x9848, 0x8DF3, 0x92B5,
	0x8DF5, 0x9148,
	0x8E0A, 0x9778, 0x8E0F, 0x93A5,
	0x8E35, 0xE6F9, 0x8E42, 0xE6F8,
	0x8E44, 0x92FB,
	0x8E5F, 0x90D6,
	0x8E74, 0x8F52,
	0x8E8D, 0x96F4,
	0x8EAB, 0x9067,
	0x8EAF, 0x8BEB, 0x8EBE, 0xE75E,
	0x8ECA, 0x8ED4,
	0x8ECB, 0xE761, 0x8ECC, 0x8B4F, 0x8ECD, 0x8C52,
	0x8ED2, 0x8CAC, 0x8EDF, 0x93EE, 0x8EE2, 0x935D,
	0x8EF8, 0x8EB2,
	0x8EFD, 0x8C79, 0x8F03, 0x8A72,
	0x8F09, 0x8DDA, 0x8F0C, 0xE771,
	0x8F14, 0x95E3,
	0x8F1D, 0x8B50,
	0x8F29, 0x9479, 0x8F2A, 0x97D6,
	0x8F2F, 0x8F53, 0x8F33, 0xE773, 0x8F38, 0x9741,
	0x8F3B, 0xE774, 0x8F3F, 0x9760,
	0x8F44, 0x8A8D,
	0x8F4D, 0x9351,
	0x8F5F, 0x8D8C, 0x8F61, 0x8C44, 0x8F62, 0xE780,
	0x8F9B, 0x9068,
	0x8F9E, 0x8EAB, 0x8FA3, 0xE785,
	0x8FB0, 0x9243, 0x8FB1, 0x904A, 0x8FB2, 0x945F,
	0x8FBA, 0x95D3, 0x8FBB, 0x92D2, 0x8FBC, 0x8D9E, 0x8FBF, 0x9248,
	0x8FC2, 0x8949, 0x8FC4, 0x9698, 0x8FC5, 0x9076, 0x8FCE, 0x8C7D,
	0x8FD1, 0x8BDF, 0x8FD4, 0x95D4,
	0x8FE6, 0x89DE, 0x8FE9, 0x93F4,
	0x8FEB, 0x9497, 0x8FED, 0x9352, 0x8FF0, 0x8F71,
	0x8FF7, 0x96C0,
	0x8FFD, 0x92C7, 0x9000, 0x91DE, 0x9001, 0x9197,
	0x9003, 0x93A6, 0x9006, 0x8B74,
	0x900F, 0x93A7, 0x9010, 0x9280,
	0x9013, 0x92FC, 0x9014, 0x9372,
	0x9017, 0x9080, 0x9019, 0x9487, 0x901A, 0x92CA,
	0x901D, 0x90C0, 0x901F, 0x91AC, 0x9020, 0x91A2,
	0x9022, 0x88A7, 0x9023, 0x9841,
	0x902E, 0x91DF, 0x9031, 0x8F54, 0x9032, 0x9069,
	0x9038, 0x88ED, 0x903C, 0x954E,
	0x9041, 0x93D9, 0x9042, 0x908B, 0x9045, 0x9278,
	0x9047, 0x8BF6, 0x904A, 0x9756, 0x904B, 0x895E,
	0x904D, 0x95D5, 0x904E, 0x89DF,
	0x9053, 0x93B9, 0x9054, 0x9242,
	0x9055, 0x88E1, 0x9059, 0xEAA1,
	0x905C, 0x91BB, 0x9060, 0x8993, 0x9061, 0x916B,
	0x9063, 0x8CAD, 0x9065, 0x9779,
	0x9069, 0x934B, 0x906D, 0x9198, 0x906E, 0x8ED5,
	0x9075, 0x8F85, 0x9077, 0x914A,
	0x9078, 0x9149, 0x907A, 0x88E2, 0x907C, 0x97C9,
	0x907F, 0x94F0,
	0x9084, 0x8AD2,
	0x9091, 0x9757, 0x90A3, 0x93DF,
	0x90A6, 0x964D, 0x90AA, 0x8ED7,
	0x90B8, 0x9340, 0x90C1, 0x88E8,
	0x90CA, 0x8D78, 0x90CE, 0x9859,
	0x90E1, 0x8C53, 0x90E8, 0x9594,
	0x90ED, 0x8A73, 0x90F5, 0x9758, 0x90F7, 0x8BBD, 0x90FD, 0x9373,
	0x912D, 0x9341,
	0x9149, 0x93D1, 0x914B, 0x8F55, 0x914C, 0x8EDE,
	0x914D, 0x947A, 0x914E, 0x9291, 0x9152, 0x8EF0, 0x9154, 0x908C,
	0x9162, 0x907C,
	0x916A, 0x978F, 0x916C, 0x8F56,
	0x9175, 0x8D79, 0x9177, 0x8D93,
	0x9178, 0x8E5F, 0x9187, 0x8F86,
	0x918D, 0x91E7, 0x9190, 0x8CED, 0x9192, 0x90C1,
	0x9197, 0x94AE, 0x919C, 0x8F58, 0x91A4, 0x8FDD,
	0x91B8, 0x8FF8,
	0x91C6, 0x94CE, 0x91C7, 0x8DD1, 0x91C8, 0x8EDF,
	0x91CC, 0x97A2, 0x91CD, 0x8F64,
	0x91CE, 0x96EC, 0x91CF, 0x97CA, 0x91D1, 0x8BE0,
	0x91D8, 0x9342,
	0x91DC, 0x8A98, 0x91DD, 0x906A,
	0x91E3, 0x92DE,
	0x91E6, 0x9674, 0x91E7, 0x8BFA,
	0x920D, 0x93DD,
	0x920E, 0x8A62,
	0x9234, 0x97E9, 0x9237, 0x8CD8,
	0x9244, 0x9353,
	0x925B, 0x8994,
	0x9262, 0x94AB, 0x9266, 0x8FDE,
	0x9271, 0x8D7A, 0x927E, 0x9667,
	0x9280, 0x8BE2, 0x9283, 0x8F65, 0x9285, 0x93BA,
	0x9291, 0x914C,
	0x9298, 0x96C1, 0x929A, 0x92B6, 0x929B, 0xE7F3,
	0x92AD, 0x914B,
	0x92CF, 0xE7F5, 0x92D2, 0x964E,
	0x92E4, 0x8F9B, 0x92EA, 0x95DD,
	0x92ED, 0x8973, 0x92F2, 0x9565, 0x92F3, 0x9292, 0x92F8, 0x8B98,
	0x92FC, 0x8D7C,
	0x9306, 0x8E4B,
	0x9310, 0x908D, 0x9318, 0x908E,
	0x9320, 0x8FF9,
	0x9326, 0x8BD1,
	0x9328, 0x9564, 0x932B, 0x8EE0, 0x932C, 0x9842,
	0x932F, 0x8DF6, 0x9332, 0x985E,
	0x934B, 0x93E7,
	0x934D, 0x9374, 0x9354, 0x92D5,
	0x935B, 0x9262, 0x936C, 0x8C4C,
	0x9375, 0x8CAE,
	0x937E, 0x8FDF, 0x938C, 0x8A99, 0x9396, 0x8DBD,
	0x9397, 0x9199, 0x939A, 0x92C8, 0x93A7, 0x8A5A,
	0x93AE, 0x92C1,
	0x93B9, 0xE850, 0x93C3, 0xE856,
	0x93D1, 0x934C,
	0x93DD, 0xE857, 0x93E1, 0x8BBE,
	0x93E8, 0xE853,
	0x9418, 0x8FE0, 0x9419, 0x93A8,
	0x9438, 0x91F6,
	0x9451, 0x8AD3,
	0x9453, 0x96F8,
	0x9577, 0x92B7, 0x9580, 0x96E5, 0x9583, 0x914D,
	0x9589, 0x95C2, 0x958B, 0x8A4A,
	0x958F, 0x895B, 0x9591, 0x8AD5, 0x9593, 0x8AD4,
	0x95A2, 0x8AD6, 0x95A3, 0x8A74, 0x95A4, 0x8D7D,
	0x95A5, 0x94B4,
	0x95B2, 0x897B,
	0x95C7, 0x88C5,
	0x95D8, 0x93AC,
	0x961C, 0x958C,
	0x962A, 0x8DE3,
	0x9632, 0x9668, 0x963B, 0x916A, 0x963F, 0x88A2, 0x9640, 0x91C9,
	0x9644, 0x958D,
	0x964D, 0x8D7E, 0x9650, 0x8CC0, 0x965B, 0x95C3,
	0x9662, 0x8940, 0x9663, 0x9077, 0x9664, 0x8F9C, 0x9665, 0x8AD7,
	0x966A, 0x9486, 0x9670, 0x8941,
	0x9673, 0x92C2, 0x9675, 0x97CB, 0x9676, 0x93A9,
	0x9678, 0x97A4, 0x967A, 0x8CAF, 0x967D, 0x977A,
	0x9685, 0x8BF7, 0x9686, 0x97B2, 0x9688, 0x8C47, 0x968A, 0x91E0,
	0x968B, 0xE440, 0x968E, 0x8A4B, 0x968F, 0x908F,
	0x9694, 0x8A75, 0x9695, 0xE8A6, 0x9698, 0xE8A5,
	0x9699, 0x8C84, 0x969B, 0x8DDB, 0x969C, 0x8FE1,
	0x96A0, 0x8942, 0x96A3, 0x97D7, 0x96A7, 0xE8A9,
	0x96B7, 0x97EA,
	0x96BB, 0x90C7, 0x96BC, 0x94B9,
	0x96C0, 0x909D, 0x96C1, 0x8AE5, 0x96C4, 0x9759, 0x96C5, 0x89EB,
	0x96C6, 0x8F57, 0x96C7, 0x8CD9,
	0x96CC, 0x8E93, 0x96D1, 0x8E47,
	0x96DB, 0x9097,
	0x96E2, 0x97A3, 0x96E3, 0x93EF, 0x96E8, 0x894A,
	0x96EA, 0x90E1, 0x96EB, 0x8EB4, 0x96F0, 0x95B5, 0x96F2, 0x895F,
	0x96F6, 0x97EB, 0x96F7, 0x978B, 0x96F9, 0xE8B9, 0x96FB, 0x9364,
	0x9700, 0x8EF9, 0x9707, 0x906B,
	0x970A, 0x97EC,
	0x971C, 0x919A, 0x971E, 0x89E0,
	0x9727, 0x96B6, 0x9732, 0x9849,
	0x9752, 0x90C2,
	0x9756, 0x96F5, 0x9759, 0x90C3,
	0x975E, 0x94F1, 0x9762, 0x96CA,
	0x9769, 0x8A76,
	0x976D, 0x9078, 0x9774, 0x8C43,
	0x9784, 0x8A93, 0x978B, 0xE8DC,
	0x978D, 0x88C6, 0x9798, 0x8FE2,
	0x97A0, 0x8B66,
	0x97AD, 0x95DA,
	0x97D3, 0x8AD8,
	0x97EE, 0x9442, 0x97F3, 0x89B9,
	0x97FB, 0x8943, 0x97FF, 0x8BBF, 0x9801, 0x95C5,
	0x9802, 0x92B8, 0x9803, 0x8DA0, 0x9805, 0x8D80, 0x9806, 0x8F87,
	0x9808, 0x907B, 0x980C, 0xE8F1, 0x9810, 0x9761,
	0x9811, 0x8AE6, 0x9812, 0x94D0, 0x9813, 0x93DA, 0x9817, 0x909C,
	0x9818, 0x97CC, 0x981A, 0x8C7A,
	0x982C, 0x966A, 0x982D, 0x93AA, 0x9834, 0x896F, 0x9837, 0xE8F5,
	0x9838, 0xE8F2, 0x983B, 0x9570, 0x983C, 0x978A,
	0x9846, 0xE8F7, 0x984C, 0x91E8, 0x984D, 0x8A7A,
	0x984E, 0x8A7B, 0x9854, 0x8AE7, 0x9855, 0x8CB0,
	0x9858, 0x8AE8, 0x985B, 0x935E, 0x985E, 0x97DE,
	0x9867, 0x8CDA,
	0x98A8, 0x9597, 0x98AF, 0xE944,
	0x98DB, 0x94F2, 0x98DF, 0x9048, 0x98E2, 0x8B51,
	0x98EF, 0x94D1, 0x98F2, 0x88F9, 0x98F4, 0x88B9, 0x98FC, 0x8E94,
	0x98FD, 0x964F, 0x98FE, 0x8FFC, 0x9905, 0x96DD,
	0x990A, 0x977B, 0x990C, 0x8961, 0x9910, 0x8E60,
	0x9913, 0x89EC,
	0x9921, 0xE951,
	0x9928, 0x8AD9,
	0x9957, 0x8BC0, 0x9996, 0x8EF1,
	0x9999, 0x8D81, 0x99A8, 0x8A5D,
	0x99AC, 0x946E, 0x99B3, 0x9279,
	0x99B4, 0x93E9, 0x99C1, 0x949D, 0x99C4, 0x91CA,
	0x99C5, 0x8977, 0x99C6, 0x8BEC, 0x99C8, 0x8BED, 0x99D0, 0x9293,
	0x99D2, 0x8BEE, 0x99D5, 0x89ED,
	0x99FF, 0x8F78,
	0x9A0E, 0x8B52, 0x9A12, 0x919B,
	0x9A13, 0x8CB1, 0x9A28, 0x91CB,
	0x9A30, 0x93AB,
	0x9A55, 0xE981, 0x9A5A, 0x8BC1,
	0x9AA8, 0x8D9C, 0x9AB8, 0x8A5B,
	0x9AC4, 0x9091, 0x9ACF, 0xE990,
	0x9AD1, 0xE991, 0x9AD3, 0xE992, 0x9AD4, 0xE993, 0x9AD8, 0x8D82,
	0x9AEA, 0x94AF,
	0x9AED, 0x9545,
	0x9B3B, 0xE2F6,
	0x9B3C, 0x8B53, 0x9B41, 0x8A40, 0x9B42, 0x8DB0,
	0x9B45, 0x96A3, 0x9B4E, 0xE9B2,
	0x9B54, 0x9682,
	0x9B5A, 0x8B9B, 0x9B6F, 0x9844,
	0x9B8E, 0x88BC,
	0x9B92, 0x95A9,
	0x9BAA, 0x968E, 0x9BAB, 0x8E4C, 0x9BAD, 0x8DF8, 0x9BAE, 0x914E,
	0x9BB9, 0xE9C1,
	0x9BC9, 0x8CEF,
	0x9BD6, 0x8E49, 0x9BDB, 0x91E2,
	0x9BE8, 0x8C7E, 0x9BF0, 0xE9CE,
	0x9BF1, 0xE9CD, 0x9BF5, 0x88B1,
	0x9C0D, 0x8A82, 0x9C10, 0x986B,
	0x9C24, 0xE9DC,
	0x9C2D, 0x9568, 0x9C2F, 0x88F1,
	0x9C39, 0x8A8F, 0x9C3A, 0xE9CB, 0x9C3B, 0x8956,
	0x9C48, 0x924C,
	0x9C52, 0x9690, 0x9C57, 0x97D8,
	0x9CE5, 0x92B9,
	0x9CE9, 0x94B5,
	0x9CF3, 0x9650, 0x9CF4, 0x96C2, 0x9CF6, 0x93CE,
	0x9D07, 0x93BC,
	0x9D0E, 0x89A8,
	0x9D1B, 0x8995,
	0x9D28, 0x8A9B, 0x9D2B, 0x8EB0, 0x9D2C, 0x89A7,
	0x9D3B, 0x8D83,
	0x9D5C, 0x894C,
	0x9D60, 0x8D94, 0x9D61, 0x96B7,
	0x9D6C, 0x9651,
	0x9D8F, 0x8C7B,
	0x9DB4, 0x92DF,
	0x9DF2, 0x9868, 0x9DF9, 0x91E9,
	0x9DFA, 0x8DEB,
	0x9E78, 0x8CB2,
	0x9E7F, 0x8EAD,
	0x9E93, 0x985B, 0x9E97, 0x97ED,
	0x9E9F, 0x97D9, 0x9EA6, 0x949E,
	0x9EB9, 0x8D8D, 0x9EBA, 0x96CB, 0x9EBB, 0x9683,
	0x9EBF, 0x969B, 0x9EC4, 0x89A9,
	0x9ECD, 0x8B6F,
	0x9ED2, 0x8D95,
	0x9ED9, 0x96D9, 0x9EDB, 0x91E1,
	0x9F0E, 0x9343, 0x9F13, 0x8CDB,
	0x9F20, 0x916C,
	0x9F3B, 0x9540, 0x9F4B, 0xE256,
	0x9F62, 0x97EE,
	0x9F8D, 0x97B4,
	0xFF01, 0x8149,
	0xFF03, 0x8194, 0xFF04, 0x8190, 0xFF05, 0x8193,
	0xFF06, 0x8195, 0xFF08, 0x8169, 0xFF09, 0x816A,
	0xFF0A, 0x8196, 0xFF0B, 0x817B, 0xFF0C, 0x8143, 0xFF0D, 0x817C,
	0xFF0E, 0x8144, 0xFF0F, 0x815E, 0xFF10, 0x824F, 0xFF11, 0x8250,
	0xFF12, 0x8251, 0xFF13, 0x8252, 0xFF14, 0x8253, 0xFF15, 0x8254,
	0xFF16, 0x8255, 0xFF17, 0x8256, 0xFF18, 0x8257, 0xFF19, 0x8258,
	0xFF1A, 0x8146, 0xFF1B, 0x8147, 0xFF1C, 0x8183, 0xFF1D, 0x8181,
	0xFF1E, 0x8184, 0xFF1F, 0x8148, 0xFF20, 0x8197, 0xFF21, 0x8260,
	0xFF22, 0x8261, 0xFF23, 0x8262, 0xFF24, 0x8263, 0xFF25, 0x8264,
	0xFF26, 0x8265, 0xFF27, 0x8266, 0xFF28, 0x8267, 0xFF29, 0x8268,
	0xFF2A, 0x8269, 0xFF2B, 0x826A, 0xFF2C, 0x826B, 0xFF2D, 0x826C,
	0xFF2E, 0x826D, 0xFF2F, 0x826E, 0xFF30, 0x826F, 0xFF31, 0x8270,
	0xFF32, 0x8271, 0xFF33, 0x8272, 0xFF34, 0x8273, 0xFF35, 0x8274,
	0xFF36, 0x8275, 0xFF37, 0x8276, 0xFF38, 0x8277, 0xFF39, 0x8278,
	0xFF3A, 0x8279, 0xFF3B, 0x816D, 0xFF3C, 0x815F, 0xFF3D, 0x816E,
	0xFF3E, 0x814F, 0xFF3F, 0x8151, 0xFF40, 0x814D, 0xFF41, 0x8281,
	0xFF42, 0x8282, 0xFF43, 0x8283, 0xFF44, 0x8284, 0xFF45, 0x8285,
	0xFF46, 0x8286, 0xFF47, 0x8287, 0xFF48, 0x8288, 0xFF49, 0x8289,
	0xFF4A, 0x828A, 0xFF4B, 0x828B, 0xFF4C, 0x828C, 0xFF4D, 0x828D,
	0xFF4E, 0x828E, 0xFF4F, 0x828F, 0xFF50, 0x8290, 0xFF51, 0x8291,
	0xFF52, 0x8292, 0xFF53, 0x8293, 0xFF54, 0x8294, 0xFF55, 0x8295,
	0xFF56, 0x8296, 0xFF57, 0x8297, 0xFF58, 0x8298, 0xFF59, 0x8299,
	0xFF5A, 0x829A, 0xFF5B, 0x816F, 0xFF5C, 0x8162, 0xFF5D, 0x8170,
	0xFF5E, 0x8160, 0xFF61, 0x00A1, 0xFF62, 0x00A2, 0xFF63, 0x00A3,
	0xFF64, 0x00A4, 0xFF65, 0x00A5, 0xFF66, 0x00A6, 0xFF67, 0x00A7,
	0xFF68, 0x00A8, 0xFF69, 0x00A9, 0xFF6A, 0x00AA, 0xFF6B, 0x00AB,
	0xFF6C, 0x00AC, 0xFF6D, 0x00AD, 0xFF6E, 0x00AE, 0xFF6F, 0x00AF,
	0xFF70, 0x00B0, 0xFF71, 0x00B1, 0xFF72, 0x00B2, 0xFF73, 0x00B3,
	0xFF74, 0x00B4, 0xFF75, 0x00B5, 0xFF76, 0x00B6, 0xFF77, 0x00B7,
	0xFF78, 0x00B8, 0xFF79, 0x00B9, 0xFF7A, 0x00BA, 0xFF7B, 0x00BB,
	0xFF7C, 0x00BC, 0xFF7D, 0x00BD, 0xFF7E, 0x00BE, 0xFF7F, 0x00BF,
	0xFF80, 0x00C0, 0xFF81, 0x00C1, 0xFF82, 0x00C2, 0xFF83, 0x00C3,
	0xFF84, 0x00C4, 0xFF85, 0x00C5, 0xFF86, 0x00C6, 0xFF87, 0x00C7,
	0xFF88, 0x00C8, 0xFF89, 0x00C9, 0xFF8A, 0x00CA, 0xFF8B, 0x00CB,
	0xFF8C, 0x00CC, 0xFF8D, 0x00CD, 0xFF8E, 0x00CE, 0xFF8F, 0x00CF,
	0xFF90, 0x00D0, 0xFF91, 0x00D1, 0xFF92, 0x00D2, 0xFF93, 0x00D3,
	0xFF94, 0x00D4, 0xFF95, 0x00D5, 0xFF96, 0x00D6, 0xFF97, 0x00D7,
	0xFF98, 0x00D8, 0xFF99, 0x00D9, 0xFF9A, 0x00DA, 0xFF9B, 0x00DB,
	0xFF9C, 0x00DC, 0xFF9D, 0x00DD, 0xFF9E, 0x00DE, 0xFF9F, 0x00DF,
	0xFFE0, 0x8191, 0xFFE1, 0x8192, 0xFFE2, 0x81CA, 0xFFE3, 0x8150,
	0xFFE5, 0x818F, 0, 0
};






WCHAR ff_convert (	/* Converted code, 0 means conversion error */
	WCHAR	src,	/* Character code to be converted */
	UINT	dir		/* 0: Unicode to OEMCP, 1: OEMCP to Unicode */
)
{
	const prog_uint16_t *p;
	WCHAR c, d;
	int i, n, li, hi;


	if (src <= 0x80) {	/* ASCII */
		c = src;
	} else {
		if (dir) {		/* OEMCP to unicode (Incremental search)*/
			p = &uni2sjis[1];
			do {
				c = pgm_read_word(p);
				p += 2;
			} while (c && c != src);
			c = pgm_read_word(p - 3);
		} else {		/* Unicode to OEMCP */
			li = 0; hi = sizeof(uni2sjis) / 4 - 1;
			for (n = 16; n; n--) {
				i = li + (hi - li) / 2;
				d = pgm_read_word(&uni2sjis[i * 2]);
				if (src == d) break;
				if (src > d)
					li = i;
				else
					hi = i;
			}
			c = n ? pgm_read_word(&uni2sjis[i * 2 + 1]) : 0;
		}
	}

	return c;
}



WCHAR ff_wtoupper (	/* Upper converted character */
	WCHAR chr		/* Input character */
)
{
	int i;
	static const prog_uint16_t tbl_lower[] = { 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x3B1, 0x3B2, 0x3B3, 0x3B4, 0x3B5, 0x3B6, 0x3B7, 0x3B8, 0x3B9, 0x3BA, 0x3BB, 0x3BC, 0x3BD, 0x3BE, 0x3BF, 0x3C0, 0x3C1, 0x3C3, 0x3C4, 0x3C5, 0x3C6, 0x3C7, 0x3C8, 0x3C9, 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437, 0x438, 0x439, 0x43A, 0x43B, 0x43C, 0x43D, 0x43E, 0x43F, 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447, 0x448, 0x449, 0x44A, 0x44B, 0x44C, 0x44D, 0x44E, 0x44F, 0x451, 0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A, 0 };
	static const prog_uint16_t tbl_upper[] = { 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x391, 0x392, 0x393, 0x394, 0x395, 0x396, 0x397, 0x398, 0x399, 0x39A, 0x39B, 0x39C, 0x39D, 0x39E, 0x39F, 0x3A0, 0x3A1, 0x3A3, 0x3A4, 0x3A5, 0x3A6, 0x3A7, 0x3A8, 0x3A9, 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417, 0x418, 0x419, 0x41A, 0x41B, 0x41C, 0x41D, 0x41E, 0x41F, 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427, 0x428, 0x429, 0x42A, 0x42B, 0x42C, 0x42D, 0x42E, 0x42F, 0x401, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168, 0x2169, 0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 0xFF28, 0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 0xFF30, 0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 0xFF37, 0xFF38, 0xFF39, 0xFF3A, 0 };


	for (i = 0; pgm_read_word(&tbl_lower[i]) && chr != pgm_read_word(&tbl_lower[i]); i++) ;

	return pgm_read_word(&tbl_lower[i]) ? pgm_read_word(&tbl_upper[i]) : chr;
}
#endif