//
// Piezo buzzer common operations library
//
// Department of Mechatronics
// Tallinn University of Technology
//  Copyrights 2011
//
#ifdef __AVR_ATmega2561__
//
// Use IO and delay operations
//
#include "pin.h"
#include "delay.h"

//
// Include buzzer.h for definitions
//
#include "module/buzzer.h"

//
// produce buzzer sound with frequency 1-255 and suitable length
//
void buzzer_sound (uint16_t freq, unsigned int length)
{
	// set buzzer pin
	pin buzzer = PIN(G,5);

	// set direction as output
	pin_setup_output(buzzer);

	// init Timer 0 in Fast PWM mode with OCR0A top and COM0B1 output
	TCCR0A |= (1 << COM0B1);
	TCCR0A |= ((1 << WGM01)|(1 << WGM00));
	TCCR0B |= (1 << WGM02);
	OCR0A = freq;
	// start Timer 0 with prescaler 1024
	TCCR0B |= ((1 << CS02)|(1 << CS00));

	// delay as the length of the sound
	sw_delay_ms(length);

	// timer stop = buzzer cut off
	timer0_stop();
}
#endif
