/*
 * usb.h
 *
 * Created: 8.01.2014 14:37:09
 *  Author: Rain
 */


#ifndef USB_H_
#define USB_H_

#include "Descriptors.h"

#include "LUFA/Drivers/USB/USB.h"
#include "LUFA/Platform/Platform.h"
#include "../pin.h"

extern USB_ClassInfo_CDC_Device_t VirtualSerial_CDC_Interface;


//
// Initialize USB CDC interface
//
void usb_init();

//
// Get USB status
// returns 1 - USB connected
// returns 0 - USB disconnected
//
uint8_t usb_get_status();
//
// Sends char via USB
//
void usb_send_char(char character);
//
// Send string via USB
//
void usb_send_string(char *string);
//
// Receives byte via USB
//
uint8_t usb_read_byte();
void usb_task();

void EVENT_USB_Device_Connect(void);
void EVENT_USB_Device_Disconnect(void);
void EVENT_USB_Device_ConfigurationChanged(void);
void EVENT_USB_Device_ControlRequest(void);

#endif /* USB_H_ */