//
// ZigBee module common operations library
//
// Department of Mechatronics
// Tallinn University of Technology
//  Copyrights 2011
//

//
// Include file only once
//
#ifndef _ZIGBEE_H_
#define _ZIGBEE_H_

//
// Include common, USART functions
//
#include "common.h"
#include "usart.h"

//
// Include LCD functions
//
#include "module/lcd_gfx.h"

//
// C++ compatibility
//
#ifdef __cplusplus
extern "C" {
#endif

//ZigBee module adress type as string
typedef struct
{
	char address64h[9];
	char address64l[9];
} zigbee_node_t;

//
//Find and save addresses of other ZigBee modules around
//
void zigbee_find_nodes(usart port, zigbee_node_t *nodelist, uint8_t maxlen);

//
// Set ZigBee module to send & receive data to chosen other ZigBee node
//
void zigbee_set_destination(usart port, zigbee_node_t *node);

//
// Writes address list of other discovered ZigBee modules into LCD
//
void zigbee_lcd_show_nodes(uint8_t startline, zigbee_node_t *nodelist, uint8_t maxlen);

//
// C++ compatibility
//
#ifdef __cplusplus
}
#endif

#endif