//
// Sensor module common operations library
//
// Department of Mechatronics
// Tallinn University of Technology
//  Copyrights 2009
//

//
// Include file only once
//
#ifndef _SENSORS_H_
#define _SENSORS_H_

//
// Include common library
//
#include "common.h"

//
// Include pin library
//
#include "pin.h"

//
// C++ compatibility
//
#ifdef __cplusplus
extern "C" {
#endif

//
// Define conversion table(s) range
//
#define THERMISTOR_TABLE_MIN_TEMP   -20
#define THERMISTOR_TABLE_MAX_TEMP    100

//
// Temperature to ADC value conversion table(s)
//
extern const unsigned short THERMISTOR_TEMP_ADC_TABLE[];

//
// Calculate temperature in celsius
// from the temperature to ADC value conversion table
//
extern signed short thermistor_calculate_celsius_from_table(
    const unsigned short *table_ptr,
    signed short min_temp,
    signed short max_temp,
    unsigned short adc_value);

//
// Short form of celsius calculation
//
#define thermistor_calculate_celsius(adc_value) \
	thermistor_calculate_celsius_from_table(THERMISTOR_TEMP_ADC_TABLE, THERMISTOR_TABLE_MIN_TEMP, THERMISTOR_TABLE_MAX_TEMP, adc_value)

//
// IR distance sensor parameters
//
typedef const struct
{
	const int64_t a;
	const int64_t b;
	const int64_t k;
}
ir_distance_sensor;

//
// Default IR distance sensors
//
extern const ir_distance_sensor GP2Y0A21YK;

//
// Calculate IR distance sensor distance in centimeters from ADC value.
// Returns -1 if cannot calculate
//
extern signed short ir_distance_calculate_cm(ir_distance_sensor sensor, unsigned short adc_value);

//
// Ultrasonic initialization
//
extern void ultrasonic_async_init(pin trigger, pin echo);

//
// Ultrasonic initialization
//
extern void ultrasonic_async_setup_result_callback(void (*function_pointer)(bool));

//
// Check the readiness of ultrasonic sensor
//
extern bool ultrasonic_async_is_ready(void);

//
// Check the presence of errors
//
extern bool ultrasonic_async_has_errors(void);

//
// Check the presence of result of ultrasonic sensors
//
extern bool ultrasonic_async_has_measured(void);

//
// Start ultrasonic distance measuring
//
extern void ultrasonic_async_start_measuring(void);

//
// Get the last result of ultrasonic measuring in centimeters
//
extern unsigned short ultrasonic_async_get_result_cm(void);

//
// Instant measuring of SRF04 ultrasonic distance
//
extern unsigned short ultrasonic_measure_srf04(pin trigger, pin echo);

//
// Instant measuring of SRF05 ultrasonic distance
//
extern unsigned short ultrasonic_measure_srf05(pin triggerecho);

// Global variables to hold data
extern uint16_t dht_hum;
extern uint16_t dht_temp;

#define DHT11	1
#define DHT22	2

// Read humidity and temperature data and update global variables
// Input sensor pin
int8_t DHT_update(uint8_t sensor,pin dht_pin);

//
// C++ compatibility
//
#ifdef __cplusplus
}
#endif

#endif
