//
// Motors module common operations library
//
// Department of Mechatronics
// Tallinn University of Technology
//  Copyrights 2009
//

//
// Include file only once
//
#ifndef _MOTORS_H_
#define _MOTORS_H_

//
// Include common library
//
#include "common.h"
#include "pin.h"

/*#if defined (__AVR_ATmega128__)
#include "../timer128.h"
#elif defined (__AVR_ATmega2561__)
#include "../timer2561.h"
#endif*/

#include "timer.h"

#if defined (__AVR_ATxmega128A1U__)
#include "xmega/TC_driver.h"
#include "xmega/port_driver.h"
#endif

//
// C++ compatibility
//
#ifdef __cplusplus
extern "C" {
#endif

//
// Initialize specified DC-motor
//
extern void dcmotor_init(unsigned char index);

//
// Drive command for specified DC-motor
//
extern void dcmotor_drive(unsigned char index, signed char direction);


#if defined (__AVR_ATxmega128A1U__)
#define TIMER_NO_PRESCALE	0x01
#define TIMER_PRESCALE_8	0x02
#define TIMER_PRESCALE_64	0x03
#define TIMER_PRESCALE_256	0x04
#define TIMER_PRESCALE_1024 0x05
//
// Initialize specified DC-motor PWM. Extended version.
// motor: 1-4
// prescaler: TIMER_NO_PRESCALE
//
void dcmotor_drive_pwm_init(uint8_t motor, uint8_t prescaler);
#else
//
// Initialize specified DC-motor PWM. Extended version.
// motor: 1-4
// prescaler: TIMER2_NO_PRESCALE
//
extern void dcmotor_drive_pwm_init(unsigned char index, timer2_prescale prescaler);
#endif

//
// Change PWM command for specified DC-motor
//
void dcmotor_drive_pwm(unsigned char index, signed char direction, unsigned char speed);

//
// Unipolar stepper initialization
//
extern void unipolar_init(unsigned char index);

//
// Unipolar stepper motor halfstep
//
extern void unipolar_halfstep(unsigned char index, signed char direction, unsigned short num_steps, unsigned char speed);

#ifndef __AVR_ATxmega128A1U__
//
// Bipolar stepper initialization
//
extern void bipolar_init(void);

//
// Bipolar stepper motor halfstep
//
extern void bipolar_halfstep(signed char direction, unsigned short num_steps, unsigned char speed);
#endif
//
// Initialize specified servo motor
//
extern void servomotor_init(unsigned char index);

//
// Position servo motors
// from -100 to 100
//
extern void servomotor_position(unsigned char index, signed short position);

//
// C++ compatibility
//
#ifdef __cplusplus
}
#endif

#endif
