//
// Ethernet interface common operations library
//
// Department of Mechatronics
// Tallinn University of Technology
//  Copyrights 2012
//

//
// Include file only once
//
#ifndef _ETHERNET_H_
#define _ETHERNET_H_


//
// C++ compatibility
//
#ifdef __cplusplus
extern "C" {
#endif

#include <avr/pgmspace.h>
#include "module/ip_config.h"
#include "module/dnslkup.h"
#include "module/dhcp_client.h"
#include "module/ip_arp_udp_tcp.h"
#include "module/net.h"
#include "module/websrv_help_functions.h"
#include "module/enc28j60.h"

// Define listen port for tcp/www (max range 1-254)
#define MYWWWPORT 80
#define TRANS_NUM_WEBMAC 2
#define TRANS_NUM_GWMAC 1
#define WEBSERVER_VHOST "robolabor.ee"

extern char urlvarstr[32];
extern uint8_t otherside_www_ip[4];
extern uint8_t otherside_www_gwmac[6];


//*****************************************************************************
//
// Function prototypes.
//
//*****************************************************************************

//
//	Init Ethernet driver for client application
//
void ethernet_init_client();

//
//	Get DNS IP 
//
void ethernet_getDNSIP();

//
//	Find server IP and MAC
//
void ethernet_get_server();

void browserresult_callback(uint16_t webstatuscode,uint16_t datapos __attribute__((unused)), uint16_t len __attribute__((unused)));

//
//	Init Ethernet driver for our MAC and IP
//
void ethernet_init(uint8_t *mac, uint8_t *ip);

//
//	Poll until valid data packet from Ethernet is received
//
uint16_t ethernet_get_packet (uint16_t maxlen, uint8_t* packet);

//
// Load html data from program memory into TCP send buffer
//
uint16_t ethernet_load_data (uint8_t *buf,uint16_t pos, const char *progmem_s);

//
// Load html data into TCP send buffer
//
uint16_t ethernet_load_data_var (uint8_t *buf,uint16_t pos, char *string);

//
// Display html page with preloaded data
//
void ethernet_print_webpage (uint8_t *buf,uint16_t dlen);

//
//	Send pong and wait TCP packet. Return URL.
//
uint16_t ethernet_analyse_packet(uint8_t *buf,uint16_t plen);

//
//	Sets Ethernet driver to standby mode
//
void ethernet_standby(void);



#endif /* SWITCHCONTROLLER_H */
