//
// Encoder module common operations library
//
// Department of Mechatronics
// Tallinn University of Technology
//  Copyrights 2010
//

//
// Include file only once
//
#ifndef _ENCODERS_H_
#define _ENCODERS_H_

//
// C++ compatibility
//
#ifdef __cplusplus
extern "C" {
#endif

//
// Specific encoder initialization
//
extern void encoder_init(unsigned char index);
 
//
// Reset specific encoder number of pulses
//
extern void encoder_reset_pulses(unsigned char index);

//
// Get specific encoder number of pulses
//
extern unsigned short encoder_get_pulses(unsigned char index);

//
// C++ compatibility
//
#ifdef __cplusplus
}
#endif

#endif
