//
// Piezo buzzer common operations library
//
// Department of Mechatronics
// Tallinn University of Technology
//  Copyrights 2011
//

//
// Include file only once
//
#ifndef _BUZZER_H_
#define _BUZZER_H_

//
// Include common functions
//
#include <avr/io.h>
#include "common.h"

//
// C++ compatibility
//
#ifdef __cplusplus
extern "C" {
#endif

//
// produce buzzer sound with frequency (Hz) 8Hz - 65kHz and suitable length (ms)
// freq: 8 - 65535 Hz 
// length 0 - 0xFFFF (0 is forever)
//
void buzzer_sound (uint16_t freq, uint16_t length);

//
// produce simple beep with buzzer
//
inline void buzzer_beep (void)
{
    buzzer_sound(6,200);
}

extern volatile uint16_t volume;
//
// Change speaker volume
// 0 - 4095
//
inline void buzzer_volume(uint16_t vol)
{
    volume = vol;
}

//
// C++ compatibility
//
#ifdef __cplusplus
}
#endif

#endif