/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : ft10x20_1.h
    Date                : 06.03.2012
    Font size in bytes  : 0x0338, 824
    Font width          : 11
    Font height         : 12
    Font first char     : 0x20
    Font last char      : 0x7E
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#ifndef ft10x20_1_H
#define ft10x20_1_H

#include <inttypes.h>
#include <avr/pgmspace.h>

#define ft10x20_WIDTH 11
#define ft10x20_HEIGHT 12

static const unsigned char __attribute__ ((progmem)) ft10x20[] =
{

    0x03, 0x38, 0x0B, 0x0C, 0x01, 0x20, 0x7E,
    0x05, 0x01, 0x03, 0x07, 0x05, 0x0A, 0x07, 0x01, 0x03, 0x03, 0x05, 0x05, 0x02, 0x03, 0x01, 0x03,
    0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x02, 0x06, 0x05, 0x06, 0x05,
    0x0A, 0x08, 0x06, 0x07, 0x07, 0x06, 0x06, 0x08, 0x07, 0x01, 0x05, 0x07, 0x05, 0x09, 0x07, 0x08,
    0x06, 0x08, 0x08, 0x06, 0x07, 0x07, 0x07, 0x09, 0x08, 0x07, 0x07, 0x02, 0x03, 0x02, 0x06, 0x07,
    0x02, 0x05, 0x05, 0x04, 0x05, 0x05, 0x03, 0x05, 0x05, 0x01, 0x02, 0x05, 0x01, 0x09, 0x05, 0x05,
    0x05, 0x05, 0x03, 0x04, 0x03, 0x05, 0x05, 0x09, 0x06, 0x05, 0x05, 0x03, 0x01, 0x03, 0x06,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x2F, 0x0E, 0x00, 0x00, 0x0E, 0x00, 0x04, 0x48,
    0x83, 0x0F, 0x4E, 0x80, 0x34, 0xF8, 0xE0, 0x04, 0x9C, 0x21, 0x22, 0xFF, 0x27, 0x22, 0xC4, 0xC1,
    0x01, 0x22, 0x20, 0x22, 0x1C, 0x01, 0x0C, 0x20, 0x80, 0x1D, 0x24, 0x22, 0x22, 0xC0, 0x01, 0x1C,
    0x2C, 0x22, 0x23, 0x52, 0xC2, 0x18, 0xC0, 0x01, 0x20, 0x0E, 0x00, 0x1F, 0x0C, 0x26, 0x80, 0x02,
    0xC8, 0x60, 0xF0, 0x41, 0x00, 0x14, 0xE0, 0x00, 0x14, 0x40, 0x00, 0x20, 0x00, 0x02, 0xF8, 0x00,
    0x02, 0x20, 0x00, 0x80, 0x00, 0x06, 0x04, 0x40, 0x00, 0x04, 0x00, 0x02, 0x30, 0xF8, 0x60, 0x00,
    0xFC, 0x21, 0x20, 0x02, 0x22, 0x20, 0xFC, 0x81, 0x00, 0x04, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x0C,
    0x23, 0x28, 0x42, 0x22, 0x22, 0x1C, 0x42, 0x18, 0x02, 0x22, 0x22, 0x22, 0xC2, 0x1D, 0x60, 0x80,
    0x05, 0x44, 0xE0, 0x3F, 0x40, 0x80, 0x1B, 0x16, 0x22, 0x21, 0x12, 0x22, 0x1E, 0xFC, 0x21, 0x22,
    0x12, 0x22, 0x21, 0xE4, 0x21, 0x00, 0x82, 0x23, 0x06, 0x12, 0xE0, 0x00, 0xDC, 0x21, 0x22, 0x22,
    0x22, 0x22, 0xDC, 0xC1, 0x13, 0x42, 0x22, 0x24, 0x22, 0xC2, 0x1F, 0x08, 0x02, 0x80, 0x08, 0x06,
    0x02, 0x50, 0x00, 0x05, 0x88, 0x80, 0x08, 0x04, 0x81, 0x04, 0x48, 0x80, 0x04, 0x48, 0x80, 0x04,
    0x04, 0x81, 0x08, 0x88, 0x00, 0x05, 0x50, 0x00, 0x02, 0x0C, 0x20, 0x00, 0xC2, 0x22, 0x02, 0x1C,
    0x00, 0x1F, 0x08, 0x46, 0x5E, 0x14, 0xAA, 0xA0, 0x0A, 0xAB, 0xAF, 0x04, 0xCA, 0x90, 0xF0, 0x04,
    0x20, 0x80, 0x01, 0x07, 0x4C, 0x20, 0x04, 0x5C, 0x00, 0x0E, 0x00, 0xE3, 0x3F, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22, 0xDC, 0x81, 0x0F, 0x04, 0x21, 0x20, 0x02, 0x22, 0x20, 0x04, 0x81, 0x08, 0xFE,
    0x23, 0x20, 0x02, 0x22, 0x20, 0x02, 0x42, 0x10, 0xF8, 0xE0, 0x3F, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x02, 0xE2, 0x3F, 0x22, 0x20, 0x02, 0x22, 0x20, 0x02, 0x02, 0x80, 0x0F, 0x04, 0x21, 0x20,
    0x02, 0x22, 0x22, 0x22, 0x42, 0x22, 0xE8, 0xE1, 0x3F, 0x20, 0x00, 0x02, 0x20, 0x00, 0x02, 0x20,
    0xE0, 0x3F, 0xFE, 0x03, 0x18, 0x00, 0x02, 0x20, 0x00, 0xE2, 0x1F, 0xFE, 0x03, 0x02, 0x30, 0x80,
    0x04, 0x84, 0x20, 0x10, 0x00, 0xE2, 0x3F, 0x00, 0x02, 0x20, 0x00, 0x02, 0x20, 0xFE, 0x63, 0x00,
    0x38, 0x00, 0x1C, 0x00, 0x02, 0x1C, 0x38, 0x60, 0x00, 0xFE, 0xE3, 0x3F, 0x04, 0x80, 0x01, 0x20,
    0x00, 0x0C, 0x00, 0xE1, 0x3F, 0xF8, 0x40, 0x10, 0x02, 0x22, 0x20, 0x02, 0x22, 0x20, 0x04, 0x81,
    0x0F, 0xFE, 0x23, 0x02, 0x22, 0x20, 0x02, 0x22, 0xC0, 0x01, 0xF8, 0x40, 0x10, 0x02, 0x22, 0x20,
    0x82, 0x22, 0x10, 0x04, 0x83, 0x4F, 0xFE, 0x23, 0x02, 0x22, 0x20, 0x02, 0x62, 0x20, 0x0A, 0x1C,
    0x01, 0x20, 0x9C, 0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0xC2, 0x1C, 0x02, 0x20, 0x00, 0x02, 0xE0,
    0x3F, 0x02, 0x20, 0x00, 0x02, 0xE0, 0x0F, 0x00, 0x01, 0x20, 0x00, 0x02, 0x20, 0x00, 0xE1, 0x0F,
    0x06, 0x80, 0x03, 0xC0, 0x01, 0x20, 0xC0, 0x81, 0x03, 0x06, 0x60, 0x00, 0xF8, 0x00, 0x30, 0xE0,
    0x80, 0x01, 0xE0, 0x00, 0x30, 0xF8, 0x60, 0x00, 0x02, 0x42, 0x10, 0x88, 0x00, 0x07, 0x50, 0x80,
    0x08, 0x04, 0x21, 0x20, 0x02, 0x40, 0x00, 0x18, 0x00, 0x3E, 0x18, 0x40, 0x00, 0x02, 0x00, 0x30,
    0x82, 0x22, 0x24, 0x22, 0x22, 0x21, 0x0A, 0x62, 0x20, 0xFE, 0x2F, 0x80, 0x06, 0x80, 0x0F, 0x00,
    0x23, 0x80, 0xFE, 0x0F, 0x02, 0x18, 0x60, 0x00, 0x06, 0x80, 0x01, 0x20, 0x00, 0x80, 0x00, 0x08,
    0x80, 0x00, 0x08, 0x80, 0x00, 0x08, 0x80, 0x02, 0x60, 0x00, 0x10, 0x81, 0x28, 0x48, 0x82, 0x14,
    0xF0, 0xE3, 0x3F, 0x10, 0x81, 0x20, 0x08, 0x02, 0x1F, 0xF0, 0x81, 0x20, 0x08, 0x02, 0x19, 0xF0,
    0x81, 0x20, 0x08, 0x02, 0x11, 0xFE, 0x03, 0x1F, 0x48, 0x82, 0x24, 0x48, 0x02, 0x17, 0x08, 0xC0,
    0x3F, 0x0A, 0x00, 0x5F, 0x08, 0x8A, 0xA0, 0x10, 0x89, 0x7F, 0xFE, 0x03, 0x01, 0x08, 0x80, 0x00,
    0xF0, 0xA3, 0x3F, 0x00, 0xA8, 0x7F, 0xFE, 0x03, 0x04, 0xE0, 0x00, 0x11, 0x08, 0xE2, 0x3F, 0xF8,
    0x03, 0x01, 0x08, 0x80, 0x00, 0xF0, 0x83, 0x00, 0x08, 0x80, 0x00, 0xF0, 0x83, 0x3F, 0x10, 0x80,
    0x00, 0x08, 0x00, 0x3F, 0xF0, 0x81, 0x20, 0x08, 0x82, 0x20, 0xF0, 0x81, 0xFF, 0x10, 0x81, 0x20,
    0x08, 0x02, 0x1F, 0xF0, 0x81, 0x20, 0x08, 0x02, 0x11, 0xF8, 0x8F, 0x3F, 0x08, 0x80, 0x00, 0x30,
    0x81, 0x24, 0x48, 0x02, 0x19, 0x08, 0xE0, 0x1F, 0x08, 0x82, 0x1F, 0x00, 0x02, 0x20, 0x00, 0x81,
    0x3F, 0x18, 0x00, 0x1E, 0x00, 0x02, 0x1E, 0x18, 0x80, 0x01, 0xE0, 0x00, 0x30, 0xF0, 0x80, 0x00,
    0xF0, 0x00, 0x30, 0xE0, 0x80, 0x01, 0x08, 0x02, 0x11, 0xA0, 0x00, 0x0E, 0x10, 0x81, 0x20, 0x18,
    0x08, 0x8E, 0x00, 0x07, 0x0E, 0x18, 0x80, 0x30, 0x88, 0x82, 0x24, 0x28, 0x82, 0x21, 0x40, 0xC0,
    0x7B, 0x02, 0xE8, 0xFF, 0x02, 0xC8, 0x7B, 0x40, 0x00, 0x04, 0x20, 0x00, 0x02, 0x40, 0x00, 0x04,
    0x20, 0x00
};

#endif

