/*
    created with FontEditor written by H. Reddmann
    HaReddmann at t-online dot de

    File Name           : f20x19_1.h
    Date                : 06.03.2012
    Font size in bytes  : 0x081C, 2076
    Font width          : 20
    Font height         : 19
    Font first char     : 0x20
    Font last char      : 0xB0
    Font bits per pixel : 1
    Font is compressed  : false

    The font data are defined as

    struct _FONT_ {
     // common shared fields
       uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
       uint8_t    font_Width_in_Pixel_for_fixed_drawing;
       uint8_t    font_Height_in_Pixel_for_all_Characters;
       uint8_t    font_Bits_per_Pixels;
                    // if MSB are set then font is a compressed font
       uint8_t    font_First_Char;
       uint8_t    font_Last_Char;
       uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
                    // for each character the separate width in pixels,
                    // characters < 128 have an implicit virtual right empty row
                    // characters with font_Char_Widths[] == 0 are undefined

     // if compressed font then additional fields
       uint8_t    font_Byte_Padding;
                    // each Char in the table are aligned in size to this value
       uint8_t    font_RLE_Table[3];
                    // Run Length Encoding Table for compression
       uint8_t    font_Char_Size_in_Bytes[font_Last_Char - font_First_Char +1];
                    // for each char the size in (bytes / font_Byte_Padding) are stored,
                    // this get us the table to seek to the right beginning of each char
                    // in the font_data[].

     // for compressed and uncompressed fonts
       uint8_t    font_data[];
                    // bit field of all characters
    }
*/

#ifndef f20x19_H
#define f20x19_H

#include <inttypes.h>
#include <avr/pgmspace.h>

#define f20x19_WIDTH 20
#define f20x19_HEIGHT 19

static const unsigned char  __attribute__ ((progmem)) f20x19[] = { //
    0x08, 0x1C, 0x14, 0x13, 0x01, 0x20, 0xB0,
    0x09, 0x02, 0x05, 0x0B, 0x09, 0x0E, 0x0C, 0x02, 0x05, 0x05, 0x05, 0x0A, 0x02, 0x05, 0x02, 0x06, 
    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x02, 0x02, 0x09, 0x09, 0x09, 0x09, 
    0x12, 0x0D, 0x0A, 0x0C, 0x0B, 0x0A, 0x09, 0x0D, 0x0B, 0x02, 0x07, 0x0B, 0x08, 0x0D, 0x0B, 0x0D, 
    0x0A, 0x0D, 0x0B, 0x0B, 0x0A, 0x0B, 0x0D, 0x13, 0x0D, 0x0C, 0x0B, 0x04, 0x06, 0x04, 0x07, 0x0B, 
    0x03, 0x09, 0x09, 0x08, 0x09, 0x09, 0x06, 0x09, 0x08, 0x02, 0x03, 0x08, 0x02, 0x0E, 0x08, 0x09, 
    0x09, 0x09, 0x05, 0x08, 0x05, 0x08, 0x09, 0x0D, 0x09, 0x09, 0x09, 0x06, 0x02, 0x06, 0x09, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x06, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x7F, 0x83, 0xFF, 0x1B, 0x7C, 0x00, 0xE0, 0x03, 0x00, 0x00, 
    0x00, 0xF8, 0x00, 0xC0, 0x07, 0x00, 0x30, 0x06, 0x80, 0x31, 0x03, 0xCC, 0x1F, 0xF0, 0x3F, 0xE0, 
    0x6F, 0x00, 0x1B, 0x33, 0xC0, 0xFC, 0x01, 0xFF, 0x03, 0xFE, 0x06, 0xB0, 0x31, 0x00, 0x8C, 0x01, 
    0x70, 0x30, 0xC0, 0x87, 0x03, 0x67, 0x38, 0x18, 0x83, 0xE1, 0xFF, 0x3F, 0x86, 0x61, 0x30, 0x9C, 
    0x03, 0xC3, 0x0F, 0x10, 0x3C, 0xC0, 0x07, 0x00, 0x7F, 0x00, 0x08, 0x02, 0x41, 0x10, 0x0E, 0xFE, 
    0x38, 0xE0, 0x73, 0x00, 0xE0, 0x01, 0xC0, 0x03, 0x00, 0xE7, 0x03, 0x8E, 0x3F, 0x38, 0x04, 0x41, 
    0x20, 0x08, 0x00, 0x7F, 0x00, 0xF0, 0x01, 0x80, 0x07, 0x70, 0x7E, 0xC0, 0x3F, 0x07, 0xF3, 0x30, 
    0x18, 0x87, 0xC1, 0x78, 0x0C, 0x7E, 0x36, 0xE0, 0xE1, 0x01, 0x00, 0x06, 0x00, 0x7C, 0x00, 0x60, 
    0x06, 0x00, 0x20, 0xF8, 0x00, 0xC0, 0x07, 0x00, 0x80, 0x1F, 0x80, 0xFF, 0x07, 0x0E, 0x70, 0x18, 
    0x00, 0x26, 0x00, 0x40, 0x01, 0x00, 0x32, 0x00, 0x0C, 0x07, 0x38, 0xF0, 0xFF, 0x00, 0xFC, 0x00, 
    0x02, 0x00, 0xD0, 0x00, 0xE0, 0x01, 0x00, 0x34, 0x00, 0x20, 0x00, 0x00, 0x60, 0x00, 0x00, 0x03, 
    0x00, 0x18, 0x00, 0xC0, 0x00, 0xE0, 0x7F, 0x00, 0xFF, 0x03, 0x80, 0x01, 0x00, 0x0C, 0x00, 0x60, 
    0x00, 0x00, 0x03, 0x00, 0x00, 0x13, 0x00, 0x78, 0x00, 0x0C, 0x00, 0x60, 0x00, 0x00, 0x03, 0x00, 
    0x18, 0x00, 0xC0, 0x00, 0x00, 0x60, 0x00, 0x00, 0x03, 0x00, 0x18, 0x00, 0xF8, 0x00, 0xFC, 0x01, 
    0xFC, 0x01, 0xF8, 0x00, 0xC0, 0x00, 0x00, 0xF0, 0x0F, 0xE0, 0xFF, 0x81, 0x03, 0x1C, 0x0C, 0xC0, 
    0x60, 0x00, 0x06, 0x03, 0x30, 0x38, 0xC0, 0x81, 0xFF, 0x07, 0xF0, 0x0F, 0x00, 0x00, 0x00, 0x18, 
    0x00, 0xE0, 0x00, 0x80, 0x03, 0x00, 0x0E, 0x00, 0xF8, 0xFF, 0xC1, 0xFF, 0x0F, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x06, 0x18, 0x38, 0xE0, 0xE0, 0x80, 0x07, 0x03, 0x36, 0x18, 0x98, 0xC1, 0x60, 0x0C, 
    0x8E, 0x61, 0xE0, 0x07, 0x03, 0x1E, 0x18, 0x30, 0x30, 0xC0, 0x81, 0x03, 0x07, 0x38, 0x18, 0x83, 
    0xC1, 0x18, 0x0C, 0xC6, 0x60, 0xE0, 0x8F, 0x03, 0xEE, 0x0F, 0x00, 0x3E, 0x00, 0xE0, 0x00, 0x80, 
    0x07, 0x00, 0x36, 0x00, 0x9C, 0x01, 0x70, 0x0C, 0xC0, 0x60, 0x00, 0xFF, 0x1F, 0xFC, 0xFF, 0x00, 
    0xC0, 0x00, 0xF0, 0x0C, 0xF8, 0xE7, 0xC0, 0x13, 0x0E, 0xC6, 0x60, 0x30, 0x06, 0x83, 0x31, 0x18, 
    0x8C, 0xE1, 0x60, 0xF8, 0x03, 0x80, 0x0F, 0xC0, 0x3F, 0x00, 0xFF, 0x07, 0x9C, 0x31, 0x30, 0x06, 
    0x83, 0x31, 0x18, 0x8C, 0xC1, 0xE0, 0x1C, 0x07, 0xCE, 0x1F, 0x60, 0x7C, 0xC0, 0x00, 0x00, 0x06, 
    0x00, 0x30, 0x80, 0x83, 0x81, 0x1F, 0x0C, 0x1F, 0x60, 0x1E, 0x00, 0x1B, 0x00, 0x78, 0x00, 0xC0, 
    0x00, 0x00, 0x78, 0x1E, 0xE0, 0xFF, 0x81, 0xF3, 0x18, 0x0C, 0xC3, 0x60, 0x18, 0x06, 0xC3, 0x30, 
    0x38, 0xCF, 0x81, 0xFF, 0x07, 0x78, 0x1E, 0xC0, 0xC7, 0x00, 0x7F, 0x0E, 0x1C, 0xE7, 0x60, 0x30, 
    0x06, 0x83, 0x31, 0x18, 0x8C, 0x81, 0x31, 0x06, 0xFC, 0x3F, 0x80, 0x7F, 0x00, 0x18, 0x18, 0xC0, 
    0xC0, 0x00, 0x06, 0x26, 0x30, 0xF0, 0x00, 0x04, 0x00, 0x70, 0x00, 0x80, 0x02, 0x00, 0x36, 0x00, 
    0xB0, 0x01, 0x80, 0x08, 0x00, 0xC6, 0x00, 0x30, 0x06, 0xC0, 0x60, 0x00, 0xCC, 0x00, 0x60, 0x06, 
    0x00, 0x33, 0x00, 0x98, 0x01, 0xC0, 0x0C, 0x00, 0x66, 0x00, 0x30, 0x03, 0x80, 0x19, 0x00, 0xCC, 
    0x00, 0x30, 0x18, 0x00, 0x63, 0x00, 0x18, 0x03, 0x80, 0x08, 0x00, 0x6C, 0x00, 0x60, 0x03, 0x00, 
    0x0A, 0x00, 0x70, 0x00, 0x00, 0x01, 0xC0, 0x00, 0x00, 0x07, 0x00, 0x1C, 0x00, 0x60, 0xE0, 0x06, 
    0x83, 0x37, 0x18, 0x0E, 0xC0, 0x39, 0x00, 0xFC, 0x00, 0xC0, 0x01, 0x00, 0xE0, 0x0F, 0xC0, 0xFF, 
    0x01, 0x0F, 0x1E, 0x1C, 0xC0, 0x70, 0x78, 0x8C, 0xF1, 0x67, 0xCE, 0x71, 0x36, 0x07, 0xB3, 0x19, 
    0x98, 0xCD, 0x60, 0x6C, 0x8E, 0x67, 0xE3, 0x3F, 0xBB, 0x8F, 0x99, 0x0D, 0x6C, 0x1C, 0x30, 0xC3, 
    0xC1, 0x1D, 0xFC, 0x63, 0x80, 0x0F, 0x01, 0x00, 0x06, 0x00, 0x3C, 0x00, 0x7C, 0x00, 0xF8, 0x00, 
    0xF8, 0x06, 0xF0, 0x31, 0x80, 0x81, 0x01, 0x7C, 0x0C, 0x80, 0x6F, 0x00, 0xE0, 0x03, 0x00, 0x7C, 
    0x00, 0x00, 0x0F, 0x00, 0x60, 0xF0, 0xFF, 0x83, 0xFF, 0x1F, 0x0C, 0xC3, 0x60, 0x18, 0x06, 0xC3, 
    0x30, 0x18, 0x86, 0xC1, 0x39, 0x0C, 0xFC, 0x73, 0xC0, 0xF3, 0x01, 0x00, 0x07, 0xC0, 0x0F, 0x80, 
    0xFF, 0x01, 0x0E, 0x1C, 0x30, 0xC0, 0xC0, 0x00, 0x0C, 0x06, 0x60, 0x30, 0x00, 0x83, 0x01, 0x18, 
    0x08, 0x60, 0xC0, 0x80, 0x03, 0x0C, 0x0E, 0x40, 0x10, 0xC0, 0xFF, 0x0F, 0xFE, 0x7F, 0x30, 0x00, 
    0x83, 0x01, 0x18, 0x0C, 0xC0, 0x60, 0x00, 0x06, 0x03, 0x30, 0x38, 0xC0, 0x81, 0x03, 0x07, 0xF8, 
    0x1F, 0x00, 0x3F, 0x80, 0xFF, 0x1F, 0xFC, 0xFF, 0x60, 0x18, 0x06, 0xC3, 0x30, 0x18, 0x86, 0xC1, 
    0x30, 0x0C, 0x86, 0x61, 0x30, 0x0C, 0x83, 0x61, 0x18, 0x0C, 0xC0, 0xE0, 0xFF, 0x07, 0xFF, 0x3F, 
    0x18, 0x06, 0xC0, 0x30, 0x00, 0x86, 0x01, 0x30, 0x0C, 0x80, 0x61, 0x00, 0x0C, 0x03, 0x60, 0x00, 
    0x00, 0xF0, 0x03, 0xE0, 0x7F, 0x80, 0x07, 0x07, 0x0C, 0x30, 0x30, 0x80, 0x83, 0x01, 0x18, 0x0C, 
    0xC0, 0x60, 0x30, 0x06, 0x83, 0x31, 0x38, 0x8C, 0x81, 0x63, 0x06, 0x38, 0x3F, 0x80, 0xF8, 0x80, 
    0xFF, 0x1F, 0xFC, 0xFF, 0x00, 0x18, 0x00, 0xC0, 0x00, 0x00, 0x06, 0x00, 0x30, 0x00, 0x80, 0x01, 
    0x00, 0x0C, 0x00, 0x60, 0x00, 0xFC, 0xFF, 0xE0, 0xFF, 0x07, 0xFF, 0x3F, 0xF8, 0xFF, 0x01, 0x00, 
    0x07, 0x00, 0x78, 0x00, 0x00, 0x03, 0x00, 0x18, 0x00, 0xC0, 0xE0, 0xFF, 0x03, 0xFF, 0x0F, 0xF8, 
    0xFF, 0xC1, 0xFF, 0x0F, 0x80, 0x01, 0x00, 0x0F, 0x00, 0xFC, 0x00, 0x70, 0x0E, 0xC0, 0xE1, 0x01, 
    0x07, 0x1C, 0x18, 0xC0, 0x41, 0x00, 0x0C, 0x00, 0x40, 0xF0, 0xFF, 0x83, 0xFF, 0x1F, 0x00, 0xC0, 
    0x00, 0x00, 0x06, 0x00, 0x30, 0x00, 0x80, 0x01, 0x00, 0x0C, 0x00, 0x60, 0xF0, 0xFF, 0x83, 0xFF, 
    0x1F, 0x3C, 0x00, 0xC0, 0x1F, 0x00, 0xF0, 0x07, 0x00, 0xF8, 0x01, 0x00, 0x0C, 0x00, 0x7E, 0x00, 
    0x7F, 0x00, 0x7F, 0x00, 0x3C, 0x00, 0xE0, 0xFF, 0x07, 0xFF, 0x3F, 0xF8, 0xFF, 0xC1, 0xFF, 0x0F, 
    0x1C, 0x00, 0xC0, 0x01, 0x00, 0x38, 0x00, 0x80, 0x07, 0x00, 0x70, 0x00, 0x00, 0x0E, 0x00, 0xE0, 
    0xC0, 0xFF, 0x0F, 0xFE, 0x7F, 0x00, 0x3F, 0x00, 0xFE, 0x07, 0x38, 0x70, 0xC0, 0x00, 0x03, 0x03, 
    0x30, 0x18, 0x80, 0xC1, 0x00, 0x0C, 0x06, 0x60, 0x30, 0x00, 0x03, 0x03, 0x0C, 0x38, 0x70, 0x80, 
    0xFF, 0x01, 0xF0, 0x03, 0xF8, 0xFF, 0xC1, 0xFF, 0x0F, 0x06, 0x03, 0x30, 0x18, 0x80, 0xC1, 0x00, 
    0x0C, 0x06, 0x60, 0x30, 0x00, 0xC7, 0x01, 0xF0, 0x07, 0x00, 0x1F, 0x00, 0xE0, 0x07, 0xC0, 0xFF, 
    0x00, 0x07, 0x0E, 0x18, 0x60, 0x60, 0x00, 0x06, 0x03, 0x30, 0x18, 0x80, 0xC1, 0x00, 0x0D, 0x06, 
    0x78, 0x60, 0x80, 0x01, 0x07, 0x1E, 0xF0, 0x9F, 0x00, 0x7E, 0x04, 0xFF, 0x3F, 0xF8, 0xFF, 0xC1, 
    0x30, 0x00, 0x86, 0x01, 0x30, 0x0C, 0x80, 0xE1, 0x00, 0x0C, 0x1F, 0xE0, 0xDC, 0x01, 0x7E, 0x3C, 
    0xE0, 0xC1, 0x01, 0x00, 0x08, 0x00, 0x0C, 0xC0, 0xE1, 0x01, 0x1F, 0x0C, 0x9C, 0xE1, 0x60, 0x0C, 
    0x06, 0x43, 0x30, 0x18, 0x86, 0xC1, 0x30, 0x0C, 0x0E, 0x31, 0xE0, 0xF8, 0x01, 0x86, 0x07, 0x0C, 
    0x00, 0x60, 0x00, 0x00, 0x03, 0x00, 0x18, 0x00, 0xC0, 0xFF, 0x0F, 0xFE, 0x7F, 0x30, 0x00, 0x80, 
    0x01, 0x00, 0x0C, 0x00, 0x60, 0x00, 0x00, 0xFF, 0x07, 0xF8, 0xFF, 0x00, 0x00, 0x06, 0x00, 0x60, 
    0x00, 0x00, 0x03, 0x00, 0x18, 0x00, 0xC0, 0x00, 0x00, 0x06, 0x00, 0x18, 0xF8, 0xFF, 0xC0, 0xFF, 
    0x01, 0x06, 0x00, 0xF0, 0x01, 0x00, 0x3E, 0x00, 0x80, 0x0F, 0x00, 0xF0, 0x01, 0x00, 0x3C, 0x00, 
    0x80, 0x01, 0x00, 0x0F, 0x00, 0x1F, 0x00, 0x3E, 0x00, 0x3E, 0x00, 0x7C, 0x00, 0x60, 0x00, 0x00, 
    0x03, 0x00, 0xF8, 0x03, 0x00, 0xFF, 0x03, 0x00, 0x7F, 0x00, 0x00, 0x03, 0x00, 0x1F, 0x80, 0x3F, 
    0x80, 0x3F, 0x00, 0x1F, 0x00, 0x18, 0x00, 0xC0, 0x07, 0x00, 0xF8, 0x03, 0x00, 0xFE, 0x00, 0x00, 
    0x1F, 0x00, 0xC0, 0x00, 0xF0, 0x07, 0xFC, 0x0F, 0xF8, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x40, 0x10, 
    0x00, 0x83, 0x01, 0x1E, 0x3C, 0x78, 0xC0, 0xE3, 0x00, 0xF8, 0x03, 0x00, 0x07, 0x00, 0xFE, 0x00, 
    0x3C, 0x0E, 0xF0, 0xE0, 0x81, 0x01, 0x1E, 0x04, 0xC0, 0x00, 0x00, 0x04, 0x01, 0x00, 0x18, 0x00, 
    0xC0, 0x03, 0x00, 0x78, 0x00, 0x80, 0x07, 0x00, 0xF0, 0x1F, 0x00, 0xFF, 0x00, 0x0F, 0x00, 0x3C, 
    0x00, 0x78, 0x00, 0xC0, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x83, 0x01, 0x1C, 0x0C, 0xF0, 0x60, 
    0xE0, 0x06, 0x83, 0x33, 0x18, 0x86, 0xC1, 0x1C, 0x0C, 0x76, 0x60, 0xF0, 0x00, 0x83, 0x03, 0x18, 
    0x0C, 0xC0, 0xE0, 0xFF, 0x7F, 0xFF, 0xFF, 0x1B, 0x00, 0xD8, 0x00, 0xC0, 0x06, 0x00, 0xF0, 0x01, 
    0x00, 0xFE, 0x00, 0x80, 0x3F, 0x00, 0xC0, 0x07, 0x00, 0x30, 0x18, 0x00, 0xD8, 0x00, 0xC0, 0xFE, 
    0xFF, 0xF7, 0xFF, 0x3F, 0x20, 0x00, 0xE0, 0x01, 0xC0, 0x03, 0x00, 0x03, 0x00, 0xF0, 0x00, 0x00, 
    0x1E, 0x00, 0x80, 0x00, 0x00, 0x00, 0x30, 0x00, 0x80, 0x01, 0x00, 0x0C, 0x00, 0x60, 0x00, 0x00, 
    0x03, 0x00, 0x18, 0x00, 0xC0, 0x00, 0x00, 0x06, 0x00, 0x30, 0x00, 0x80, 0x01, 0x00, 0x2C, 0x00, 
    0x00, 0x03, 0x00, 0x30, 0x00, 0x00, 0x98, 0x07, 0xC0, 0x7E, 0x00, 0x33, 0x03, 0x98, 0x19, 0xC0, 
    0xC6, 0x00, 0x36, 0x03, 0xF0, 0x1F, 0x00, 0xFF, 0x01, 0x00, 0x08, 0xFE, 0x7F, 0xF0, 0xFF, 0x03, 
    0x30, 0x0C, 0xC0, 0xC0, 0x00, 0x06, 0x06, 0x30, 0x30, 0x80, 0xC3, 0x01, 0xF8, 0x07, 0x80, 0x1F, 
    0x00, 0xFC, 0x00, 0xF0, 0x0F, 0xC0, 0xE1, 0x00, 0x06, 0x06, 0x30, 0x30, 0x80, 0xC3, 0x01, 0x18, 
    0x06, 0x80, 0x10, 0x00, 0xFC, 0x00, 0xF0, 0x0F, 0xC0, 0xE1, 0x00, 0x06, 0x06, 0x30, 0x30, 0x80, 
    0x81, 0x01, 0x18, 0x06, 0xFE, 0x7F, 0xF0, 0xFF, 0x03, 0xE0, 0x07, 0x80, 0x7F, 0x00, 0x6E, 0x07, 
    0x30, 0x33, 0x80, 0x99, 0x01, 0xCC, 0x0C, 0xE0, 0x66, 0x00, 0xBE, 0x01, 0xC0, 0x05, 0xC0, 0x00, 
    0xC0, 0xFF, 0x07, 0xFF, 0x3F, 0x98, 0x01, 0xC0, 0x0C, 0x00, 0x06, 0x00, 0x00, 0xFC, 0x18, 0xF0, 
    0xCF, 0xC0, 0xE1, 0x0C, 0x06, 0x66, 0x30, 0x30, 0x83, 0x81, 0x19, 0x18, 0xE6, 0xE0, 0xFF, 0x03, 
    0xFF, 0x8F, 0xFF, 0x1F, 0xFC, 0xFF, 0x00, 0x0C, 0x00, 0x30, 0x00, 0x80, 0x01, 0x00, 0x0C, 0x00, 
    0xE0, 0x7F, 0x00, 0xFE, 0x83, 0xF9, 0x1F, 0xCC, 0xFF, 0x00, 0x00, 0x60, 0xF3, 0xFF, 0x9B, 0xFF, 
    0xCF, 0xFF, 0x0F, 0xFE, 0x7F, 0x00, 0x18, 0x00, 0xE0, 0x01, 0x80, 0x3F, 0x00, 0xCE, 0x07, 0x30, 
    0x38, 0x80, 0x00, 0xC1, 0xFF, 0x0F, 0xFE, 0x7F, 0x00, 0xFF, 0x03, 0xF8, 0x1F, 0x80, 0x01, 0x00, 
    0x06, 0x00, 0x30, 0x00, 0x80, 0x01, 0x00, 0xFC, 0x0F, 0x80, 0x7F, 0x00, 0x06, 0x00, 0x18, 0x00, 
    0xC0, 0x00, 0x00, 0x06, 0x00, 0xF0, 0x3F, 0x00, 0xFF, 0x01, 0xFC, 0x0F, 0xE0, 0x7F, 0x00, 0x06, 
    0x00, 0x18, 0x00, 0xC0, 0x00, 0x00, 0x06, 0x00, 0xF0, 0x3F, 0x00, 0xFF, 0x01, 0xF0, 0x03, 0xC0, 
    0x3F, 0x00, 0x87, 0x03, 0x18, 0x18, 0xC0, 0xC0, 0x00, 0x06, 0x06, 0x70, 0x38, 0x00, 0xFF, 0x00, 
    0xF0, 0x03, 0xE0, 0xFF, 0x07, 0xFF, 0x3F, 0x30, 0x0C, 0xC0, 0xC0, 0x00, 0x06, 0x06, 0x30, 0x30, 
    0x80, 0xC3, 0x01, 0xF8, 0x07, 0x80, 0x0F, 0x00, 0x7C, 0x00, 0xF0, 0x0F, 0xC0, 0xE1, 0x00, 0x06, 
    0x06, 0x30, 0x30, 0x80, 0x81, 0x01, 0x18, 0x06, 0xE0, 0xFF, 0x07, 0xFF, 0x3F, 0xF8, 0x1F, 0xC0, 
    0xFF, 0x00, 0x0C, 0x00, 0x30, 0x00, 0x80, 0x01, 0x00, 0x38, 0x02, 0xE0, 0x33, 0x00, 0x1B, 0x03, 
    0x98, 0x19, 0xC0, 0xCC, 0x00, 0xC6, 0x06, 0x60, 0x3E, 0x00, 0xE2, 0x00, 0x0C, 0x00, 0xFC, 0x3F, 
    0xE0, 0xFF, 0x03, 0x18, 0x18, 0xC0, 0xC0, 0x00, 0xFE, 0x03, 0xF0, 0x3F, 0x00, 0x80, 0x01, 0x00, 
    0x0C, 0x00, 0x60, 0x00, 0x80, 0x01, 0xF8, 0x1F, 0xC0, 0xFF, 0x00, 0x06, 0x00, 0xF0, 0x01, 0x00, 
    0x3E, 0x00, 0x80, 0x07, 0x00, 0x70, 0x00, 0xE0, 0x01, 0xE0, 0x03, 0xC0, 0x07, 0x00, 0x06, 0x00, 
    0x70, 0x00, 0x80, 0x1F, 0x00, 0xE0, 0x07, 0x00, 0x70, 0x00, 0xF0, 0x03, 0xF0, 0x01, 0xC0, 0x01, 
    0x00, 0x7C, 0x00, 0x00, 0x3F, 0x00, 0xC0, 0x01, 0xE0, 0x07, 0xE0, 0x07, 0x00, 0x07, 0x00, 0x08, 
    0x10, 0xC0, 0xC0, 0x00, 0x9C, 0x03, 0xC0, 0x0F, 0x00, 0x18, 0x00, 0xF0, 0x03, 0xC0, 0x39, 0x00, 
    0x03, 0x03, 0x08, 0x10, 0xC0, 0x00, 0x00, 0x1E, 0x60, 0xC0, 0x03, 0x03, 0x78, 0x1C, 0x00, 0x7F, 
    0x00, 0xFC, 0x00, 0xFC, 0x00, 0xF8, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x07, 0x30, 0x3C, 0x80, 0xF1, 
    0x01, 0xCC, 0x0D, 0x60, 0x66, 0x00, 0x1B, 0x03, 0xF8, 0x18, 0xC0, 0xC3, 0x00, 0x0E, 0x06, 0x00, 
    0x03, 0x00, 0x3C, 0x80, 0xFF, 0x7F, 0xFE, 0xF9, 0x37, 0x00, 0xB0, 0x01, 0x80, 0xFD, 0xFF, 0xEF, 
    0xFF, 0x7F, 0x03, 0x00, 0x1B, 0x00, 0xD8, 0x3F, 0xFF, 0xFC, 0xFF, 0x03, 0x78, 0x00, 0x80, 0x01, 
    0x00, 0x06, 0x00, 0x18, 0x00, 0xC0, 0x00, 0x00, 0x06, 0x00, 0x60, 0x00, 0x00, 0x06, 0x00, 0x30, 
    0x00, 0x80, 0x01, 0x00, 0x06, 0xE0, 0x03, 0x80, 0x3F, 0x00, 0x04, 0x01, 0x20, 0x08, 0x00, 0x7F, 
    0x00, 0xF0, 0x01, 0x00
};

#endif

