//
// Common macros and configurations
// Homelab library
//
// Department of Mechatronics
// Tallinn University of Technology
//  Copyrights 2009
//

//
// Include common.h only once
//
#ifndef _COMMON_H_
#define _COMMON_H_

//
// C++ compatibility
//
#ifdef __cplusplus
extern "C" {
#endif

//
// Define F_CPU if not defined
//
// 14.7456 MHz is homelab controller clock
//
#if defined(__AVR_ATmega2561__)
	#ifndef F_CPU
		#define F_CPU 14745600UL
		# warning "CPU clock not defined, assuming homelab controller frequency of 14.7456Mhz"
	#endif
#elif defined (__AVR_ATxmega128A1U__)
	#ifndef F_CPU
		#define F_CPU 32000000UL
		# warning "CPU clock not defined, assuming homelab controller frequency of 32Mhz"
	#endif
#endif

//
// Boolean constants
//
#ifndef true
#define true 1
#endif

#ifndef false
#define false 0
#endif

#ifndef bool
#define bool unsigned char
#endif

#ifndef NULL
#define NULL 0
#endif

//
// Private macros
// Type for registry pointer
//
#ifndef _REG_PTR_
#define _REG_PTR_ volatile uint8_t *
#endif

//
// Delay function pointer
//
typedef void(*delay_function_ptr)(unsigned short);

//
// C++ compatibility
//
#ifdef __cplusplus
}
#endif

#endif
