//
// General bit operation
// Homelab library
//
// Department of Mechatronics
// Tallinn University of Technology
//  Copyrights 2009
//

//
// Include bit.h only once
//
#ifndef _BIT_H_
#define _BIT_H_
	
//
// Common bit manipulation functions
//
#define bit_mask(bit)                  (1 << (bit))
#define bit_set(value, bit)            value |= bit_mask(bit)
#define bit_clear(value, bit)          value &= ~bit_mask(bit)
#define bit_set_to(value, bit, state)  value = ((state) ? (value | bit_mask(bit)) : (value & ~bit_mask(bit)))
#define bit_invert(value, bit)         value ^= bit_mask(bit)

// Compatibility with avrlibc
#ifndef bit_is_set
#define bit_is_set(value, bit)         ((value) & (bit_mask(bit)))
#endif

#ifndef bit_is_clear
#define bit_is_clear(value, bit)       (!((value) & (bit_mask(bit))))
#endif

//
// Bitmask manipulation
//
#define bitmask_set(value, bitMask)             value |= (bitMask)
#define bitmask_clear(value, bitMask)           value &= ~(bitMask)
#define bitmask_invert(value, bitMask)          value ^= (bitMask)
#define bitmask_set_to(value, bitMask, state)   value = ((state) ? (value | (bitMask)) : (value & ~(bitMask))) 
#define bitmask_is_set(value, bitMask)          ((value) & (bitMask))

#endif
